/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.postgres;

import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import java.io.IOException;
import javax.sql.DataSource;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.stone.beecp.BeeDataSource;
import org.stone.beecp.BeeDataSourceConfig;

public class PostgresDatabaseDriver
extends AbstractDatabaseDriver {
    private final BeeDataSource dataSource;

    public PostgresDatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        String host = section.getString("host");
        int port = section.getInt("port");
        String database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        config.setJdbcUrl("jdbc:p6spy:postgresql://" + host + ":" + port + "/" + database);
        config.setUsername(username);
        config.setPassword(password);
        config.setDriverClassName("com.p6spy.engine.spy.P6SpyDriver");
        config.setMaxActive(10);
        config.setMaxWait(30000L);
        config.setIntervalOfClearTimeout(600000L);
        config.setAliveTestSql("SELECT 1");
        config.setFairMode(true);
        config.setForceDirtyWhenSetSchema(true);
        config.addConnectionFactoryProperty("ApplicationName", (Object)"PeerBanHelper");
        config.addConnectionFactoryProperty("tcpKeepAlive", (Object)"true");
        config.addConnectionFactoryProperty("reWriteBatchedInserts", (Object)"true");
        this.dataSource = new BeeDataSource(config);
        MiscUtil.removeBeeCPShutdownHook(this.dataSource);
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.POSTGRES;
    }

    @Override
    @NotNull
    protected DataSource createDataSource() {
        return this.dataSource;
    }
}

