/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.SQLiteSchemaUpgrader;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.AlertMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.BanListMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.HistoryMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.MetadataMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.PCBAddressMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.PCBRangeMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.PeerConnectionMetricsMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.PeerConnectionMetricsTrackMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.PeerRecordMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.RuleSubInfoMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.RuleSubLogMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.TorrentMigrator;
import com.ghostchu.peerbanhelper.databasent.migration.migrators.TrafficJournalMigrator;
import com.ghostchu.peerbanhelper.databasent.service.AlertService;
import com.ghostchu.peerbanhelper.databasent.service.BanListService;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.service.MetadataService;
import com.ghostchu.peerbanhelper.databasent.service.PCBAddressService;
import com.ghostchu.peerbanhelper.databasent.service.PCBRangeService;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsService;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsTrackService;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.service.RuleSubInfoService;
import com.ghostchu.peerbanhelper.databasent.service.RuleSubLogService;
import com.ghostchu.peerbanhelper.databasent.service.TorrentService;
import com.ghostchu.peerbanhelper.databasent.service.TrafficJournalService;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import io.sentry.Sentry;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class DatabaseMigrationCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseMigrationCoordinator.class);
    @Autowired
    private AlertService alertService;
    @Autowired
    private BanListService banListService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private TorrentService torrentService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private PeerRecordService peerRecordService;
    @Autowired
    private TrafficJournalService trafficJournalService;
    @Autowired
    private RuleSubInfoService ruleSubInfoService;
    @Autowired
    private RuleSubLogService ruleSubLogService;
    @Autowired
    private PCBAddressService pcbAddressService;
    @Autowired
    private PCBRangeService pcbRangeService;
    @Autowired
    private PeerConnectionMetricsService peerConnectionMetricsService;
    @Autowired
    private PeerConnectionMetricsTrackService peerConnectionMetricsTrackService;
    @Autowired(required=false)
    private IPDBManager ipdbManager;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private final File sqliteDbFile;
    private final File migrationMarkerFile;

    public DatabaseMigrationCoordinator() {
        File persistDir = new File(Main.getDataDirectory(), "persist");
        this.sqliteDbFile = new File(persistDir, "peerbanhelper.db");
        this.migrationMarkerFile = new File(persistDir, "migration_completed.marker");
    }

    @PostConstruct
    public void checkAndMigrate() {
        if (!this.shouldMigrate()) {
            log.debug("Database migration not needed or already completed");
            return;
        }
        log.info("=".repeat(60));
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_STARTING, new Object[0]));
        log.info("=".repeat(60));
        try {
            this.performMigration();
            this.markMigrationCompleted();
            this.archiveSqliteDatabase();
            log.info("=".repeat(60));
            log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_COMPLETED, new Object[0]));
            log.info("=".repeat(60));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DBNT_MIGRATOR_FAILED, new Object[0]), (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }

    private boolean shouldMigrate() {
        if (this.migrationMarkerFile.exists()) {
            log.debug("Migration marker file exists, skipping migration");
            return false;
        }
        if (!this.sqliteDbFile.exists()) {
            log.debug("SQLite database file not found at {}, skipping migration", (Object)this.sqliteDbFile);
            return false;
        }
        log.debug("Found SQLite database at {}, migration will proceed", (Object)this.sqliteDbFile);
        return true;
    }

    private void performMigration() throws Exception {
        long startTime = System.currentTimeMillis();
        String jdbcUrl = "jdbc:sqlite:" + this.sqliteDbFile.getAbsolutePath();
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_CONNECTING_SQLITE, new Object[0]));
        try (Connection sqliteConnection = DriverManager.getConnection(jdbcUrl);){
            SQLiteSchemaUpgrader upgrader = new SQLiteSchemaUpgrader(sqliteConnection);
            upgrader.upgradeToLatest();
            MigrationContext context = new MigrationContext();
            context.setIpdbManager(this.ipdbManager);
            context.setBatchSize(500);
            context.setSkipGeoIP(false);
            List<TableMigrator> migrators = this.createMigrators();
            migrators.sort(Comparator.comparingInt(TableMigrator::getMigrationOrder));
            for (TableMigrator migrator : migrators) {
                try {
                    if (!migrator.isTableAvailable(sqliteConnection)) {
                        log.info("Table '{}' not found in SQLite, skipping", (Object)migrator.getTableName());
                        continue;
                    }
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PREPARE, migrator.getTableName()));
                    this.transactionTemplate.execute(transactionStatus -> {
                        try {
                            return migrator.migrate(sqliteConnection, context);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Failed to migrate table '{}': {}", new Object[]{migrator.getTableName(), e.getMessage(), e});
                }
            }
            long duration = System.currentTimeMillis() - startTime;
            log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_FINISHED, context.getTotalRecordsMigrated(), duration / 1000L));
        }
    }

    private List<TableMigrator> createMigrators() {
        ArrayList<TableMigrator> migrators = new ArrayList<TableMigrator>();
        migrators.add(new MetadataMigrator(this.metadataService));
        migrators.add(new TorrentMigrator(this.torrentService));
        migrators.add(new HistoryMigrator(this.historyService));
        migrators.add(new PeerRecordMigrator(this.peerRecordService));
        migrators.add(new TrafficJournalMigrator(this.trafficJournalService));
        migrators.add(new RuleSubInfoMigrator(this.ruleSubInfoService));
        migrators.add(new RuleSubLogMigrator(this.ruleSubLogService));
        migrators.add(new PCBAddressMigrator(this.pcbAddressService));
        migrators.add(new PCBRangeMigrator(this.pcbRangeService));
        migrators.add(new PeerConnectionMetricsMigrator(this.peerConnectionMetricsService));
        migrators.add(new PeerConnectionMetricsTrackMigrator(this.peerConnectionMetricsTrackService));
        migrators.add(new AlertMigrator(this.alertService));
        migrators.add(new BanListMigrator(this.banListService));
        return migrators;
    }

    private void markMigrationCompleted() {
        try {
            this.migrationMarkerFile.createNewFile();
            log.debug("Created migration marker file: {}", (Object)this.migrationMarkerFile);
        }
        catch (Exception e) {
            log.warn("Failed to create migration marker file", (Throwable)e);
        }
    }

    private void archiveSqliteDatabase() {
        if (!this.sqliteDbFile.exists()) {
            log.debug("SQLite database file not found, skipping archival");
            return;
        }
        File zipFile = new File(this.sqliteDbFile.getParentFile(), this.sqliteDbFile.getName() + ".zip");
        log.info("Archiving SQLite database to: {}", (Object)zipFile.getAbsolutePath());
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_ARCHIVING_LEGACY_TO, zipFile.getAbsolutePath()));
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);
             FileInputStream fis = new FileInputStream(this.sqliteDbFile);){
            int length;
            ZipEntry zipEntry = new ZipEntry(this.sqliteDbFile.getName());
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[8192];
            long totalBytes = this.sqliteDbFile.length();
            long readBytes = 0L;
            long lastLogTime = System.currentTimeMillis();
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
                readBytes += (long)length;
                if (System.currentTimeMillis() - lastLogTime <= 2000L) continue;
                lastLogTime = System.currentTimeMillis();
                log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_ARCHIVING_LEGACY_PROGRESS, (int)((double)readBytes / (double)totalBytes * 100.0)));
            }
            zos.closeEntry();
            if (this.sqliteDbFile.delete()) {
                log.debug("Deleted original SQLite database file: {}", (Object)this.sqliteDbFile.getAbsolutePath());
            } else {
                log.debug("Failed to delete original SQLite database file: {}", (Object)this.sqliteDbFile.getAbsolutePath());
                this.sqliteDbFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            log.error("Failed to archive SQLite database", (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }
}

