/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration;

import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class MigrationContext {
    private int batchSize = 5000;
    private IPDBManager ipdbManager;
    private Map<Long, Long> torrentIdMap = new HashMap<Long, Long>();
    private Map<String, Long> moduleIdMap = new HashMap<String, Long>();
    private boolean skipGeoIP = false;
    private long totalRecordsMigrated = 0L;

    public void incrementTotalRecords(long count) {
        this.totalRecordsMigrated += count;
    }

    public static String formatProgress(long current, long total) {
        if (total == 0L) {
            return "0%";
        }
        return String.format("%.1f%%", (double)current * 100.0 / (double)total);
    }

    public static boolean shouldLogProgress(long current, long total, long lastLogged) {
        if (total == 0L) {
            return false;
        }
        if (current == total) {
            return true;
        }
        int logInterval = Math.min((int)(total / 10L), 1000);
        if (logInterval == 0) {
            logInterval = 100;
        }
        return current - lastLogged >= (long)logInterval;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public IPDBManager getIpdbManager() {
        return this.ipdbManager;
    }

    @Generated
    public Map<Long, Long> getTorrentIdMap() {
        return this.torrentIdMap;
    }

    @Generated
    public Map<String, Long> getModuleIdMap() {
        return this.moduleIdMap;
    }

    @Generated
    public boolean isSkipGeoIP() {
        return this.skipGeoIP;
    }

    @Generated
    public long getTotalRecordsMigrated() {
        return this.totalRecordsMigrated;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setIpdbManager(IPDBManager ipdbManager) {
        this.ipdbManager = ipdbManager;
    }

    @Generated
    public void setTorrentIdMap(Map<Long, Long> torrentIdMap) {
        this.torrentIdMap = torrentIdMap;
    }

    @Generated
    public void setModuleIdMap(Map<String, Long> moduleIdMap) {
        this.moduleIdMap = moduleIdMap;
    }

    @Generated
    public void setSkipGeoIP(boolean skipGeoIP) {
        this.skipGeoIP = skipGeoIP;
    }

    @Generated
    public void setTotalRecordsMigrated(long totalRecordsMigrated) {
        this.totalRecordsMigrated = totalRecordsMigrated;
    }
}

