/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.AlertService;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertMigrator.class);
    private final AlertService alertService;

    public AlertMigrator(AlertService alertService) {
        this.alertService = alertService;
    }

    @Override
    public String getTableName() {
        return "alert";
    }

    @Override
    public int getMigrationOrder() {
        return 110;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='alert'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT createAt, readAt, level, identifier, title, content\nFROM alert\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<AlertEntity> batch = new ArrayList<AlertEntity>();
            while (rs.next()) {
                try {
                    AlertEntity entity = new AlertEntity();
                    Timestamp createAt = rs.getTimestamp("createAt");
                    Timestamp readAt = rs.getTimestamp("readAt");
                    entity.setCreateAt(createAt != null ? OffsetDateTime.ofInstant(createAt.toInstant(), ZoneId.systemDefault()) : null);
                    entity.setReadAt(readAt != null ? OffsetDateTime.ofInstant(readAt.toInstant(), ZoneId.systemDefault()) : null);
                    String levelStr = rs.getString("level");
                    try {
                        entity.setLevel(AlertLevel.valueOf(levelStr));
                    }
                    catch (Exception e) {
                        log.warn("Unknown alert level: {}", (Object)levelStr);
                        entity.setLevel(AlertLevel.INFO);
                    }
                    entity.setIdentifier(rs.getString("identifier"));
                    String titleStr = rs.getString("title");
                    String contentStr = rs.getString("content");
                    entity.setTitle(this.parseTranslationComponent(titleStr));
                    entity.setContent(this.parseTranslationComponent(contentStr));
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.alertService.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "alert", MigrationContext.formatProgress(count, totalCount)));
                    lastLogged = count;
                }
                catch (Exception e) {
                    log.error("Failed to migrate alert record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.alertService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "alert"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM alert");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for alert table", (Throwable)e);
        }
        return 0L;
    }

    private TranslationComponent parseTranslationComponent(String str) {
        if (str == null || str.isEmpty()) {
            return new TranslationComponent("");
        }
        try {
            return (TranslationComponent)JsonUtil.standard().fromJson(str, TranslationComponent.class);
        }
        catch (Exception e) {
            log.warn("Failed to parse rule name as TranslationComponent: {}", (Object)str, (Object)e);
            return new TranslationComponent(str);
        }
    }
}

