/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.RuleSubInfoService;
import com.ghostchu.peerbanhelper.databasent.table.RuleSubInfoEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSubInfoMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSubInfoMigrator.class);
    private final RuleSubInfoService ruleSubInfoService;

    public RuleSubInfoMigrator(RuleSubInfoService ruleSubInfoService) {
        this.ruleSubInfoService = ruleSubInfoService;
    }

    @Override
    public String getTableName() {
        return "rule_sub_info";
    }

    @Override
    public int getMigrationOrder() {
        return 80;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='rule_sub_info'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT ruleId, enabled, ruleName, subUrl, lastUpdate, entCount FROM rule_sub_info";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<RuleSubInfoEntity> batch = new ArrayList<RuleSubInfoEntity>();
            while (rs.next()) {
                RuleSubInfoEntity entity = new RuleSubInfoEntity();
                entity.setRuleId(rs.getString("ruleId"));
                entity.setEnabled(rs.getBoolean("enabled"));
                entity.setRuleName(rs.getString("ruleName"));
                entity.setSubUrl(rs.getString("subUrl"));
                long lastUpdateMillis = rs.getLong("lastUpdate");
                if (lastUpdateMillis > 0L) {
                    entity.setLastUpdate(OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastUpdateMillis), ZoneId.systemDefault()));
                }
                entity.setEntCount(rs.getInt("entCount"));
                batch.add(entity);
                if (batch.size() < context.getBatchSize()) continue;
                this.ruleSubInfoService.getBaseMapper().insertOrUpdate(batch);
                batch.clear();
                if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "rule_sub_info", MigrationContext.formatProgress(count, totalCount)));
                lastLogged = count;
            }
            if (!batch.isEmpty()) {
                this.ruleSubInfoService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "rule_sub_info"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM rule_sub_info");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for rule_sub_info table", (Throwable)e);
        }
        return 0L;
    }
}

