/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.RuleSubLogService;
import com.ghostchu.peerbanhelper.databasent.table.RuleSubLogEntity;
import com.ghostchu.peerbanhelper.module.IPBanRuleUpdateType;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSubLogMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSubLogMigrator.class);
    private final RuleSubLogService ruleSubLogService;

    public RuleSubLogMigrator(RuleSubLogService ruleSubLogService) {
        this.ruleSubLogService = ruleSubLogService;
    }

    @Override
    public String getTableName() {
        return "rule_sub_log";
    }

    @Override
    public int getMigrationOrder() {
        return 81;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='rule_sub_log'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT id, ruleId, updateTime, count, updateType FROM rule_sub_log";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<RuleSubLogEntity> batch = new ArrayList<RuleSubLogEntity>();
            while (rs.next()) {
                RuleSubLogEntity entity = new RuleSubLogEntity();
                entity.setId(rs.getLong("id"));
                entity.setRuleId(rs.getString("ruleId"));
                long updateTimeMillis = rs.getLong("updateTime");
                entity.setUpdateTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(updateTimeMillis), ZoneId.systemDefault()));
                entity.setCount(rs.getInt("count"));
                String updateTypeStr = rs.getString("updateType");
                try {
                    entity.setUpdateType(IPBanRuleUpdateType.valueOf(updateTypeStr));
                }
                catch (Exception e) {
                    log.warn("Unknown update type: {}, defaulting to UNKNOWN", (Object)updateTypeStr);
                }
                batch.add(entity);
                if (batch.size() < context.getBatchSize()) continue;
                this.ruleSubLogService.getBaseMapper().insertOrUpdate(batch);
                batch.clear();
                if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "rule_sub_log", MigrationContext.formatProgress(count, totalCount)));
                lastLogged = count;
            }
            if (!batch.isEmpty()) {
                this.ruleSubLogService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "rule_sub_log"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM rule_sub_log");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for rule_sub_log table", (Throwable)e);
        }
        return 0L;
    }
}

