/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.databasent.mapper.java.BanListMapper;
import com.ghostchu.peerbanhelper.databasent.service.BanListService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.BanListEntity;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import inet.ipaddr.IPAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class BanListServiceImpl
extends AbstractCommonService<BanListMapper, BanListEntity>
implements BanListService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanListServiceImpl.class);
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    @NotNull
    public Map<IPAddress, BanMetadata> readBanList() {
        HashMap<IPAddress, BanMetadata> map = new HashMap<IPAddress, BanMetadata>();
        try {
            ((BanListMapper)this.baseMapper).selectList(null).forEach(e -> map.put(IPAddressUtil.getIPAddress(e.getAddress()), (BanMetadata)JsonUtil.tiny().fromJson(e.getMetadata(), BanMetadata.class)));
        }
        catch (Exception e2) {
            log.error("Unable to read stored banlist, skipping...", (Throwable)e2);
        }
        return map;
    }

    @Override
    public int saveBanList(@NotNull BanList banlist) {
        ArrayList entityList = new ArrayList();
        banlist.forEach((key, value) -> entityList.add(new BanListEntity(key.toNormalizedString(), JsonUtil.tiny().toJson(value))));
        Integer integer = (Integer)this.transactionTemplate.execute(transactionStatus -> {
            ((BanListMapper)this.baseMapper).delete(null);
            return ((BanListMapper)this.baseMapper).insert(entityList).size();
        });
        if (integer == null) {
            return 0;
        }
        return integer;
    }
}

