/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ghostchu.peerbanhelper.databasent.mapper.java.PCBAddressMapper;
import com.ghostchu.peerbanhelper.databasent.service.PCBAddressService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.PCBAddressEntity;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PCBAddressServiceImpl
extends AbstractCommonService<PCBAddressMapper, PCBAddressEntity>
implements PCBAddressService {
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<PCBAddressEntity> fetchFromDatabase(@NotNull String torrentId, @NotNull String downloader) {
        return ((PCBAddressMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getDownloader, (Object)downloader));
    }

    @Override
    public PCBAddressEntity fetchFromDatabase(@NotNull String torrentId, @NotNull InetAddress ip, int port, @NotNull String downloader) {
        return (PCBAddressEntity)((PCBAddressMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getIp, (Object)ip)).eq(PCBAddressEntity::getPort, (Object)port)).eq(PCBAddressEntity::getDownloader, (Object)downloader));
    }

    @Override
    public int deleteEntry(@NotNull String torrentId, @NotNull InetAddress ip) {
        return ((PCBAddressMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getIp, (Object)ip));
    }

    @Override
    public long cleanupDatabase(OffsetDateTime timestamp) {
        return this.splitBatchDelete((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PCBAddressEntity::getId}).lt(PCBAddressEntity::getLastTimeSeen, (Object)timestamp));
    }
}

