/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ghostchu.peerbanhelper.databasent.dto.ClientAnalyseResult;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTimeSeen;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTotalTraffic;
import com.ghostchu.peerbanhelper.databasent.dto.TorrentCount;
import com.ghostchu.peerbanhelper.databasent.mapper.java.PeerRecordMapper;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.service.TorrentService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.databasent.table.TorrentEntity;
import com.ghostchu.peerbanhelper.util.LazyLoad;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PeerRecordServiceImpl
extends AbstractCommonService<PeerRecordMapper, PeerRecordEntity>
implements PeerRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerRecordServiceImpl.class);
    @Autowired
    private TorrentService torrentDao;
    @Autowired
    private IPDBManager ipdbManager;

    @Override
    public List<PeerRecordEntity> getRecordsBetween(OffsetDateTime start, OffsetDateTime end, String downloader) {
        return ((PeerRecordMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(PeerRecordEntity::getFirstTimeSeen, (Object)start)).le(PeerRecordEntity::getLastTimeSeen, (Object)end)).eq(downloader != null, PeerRecordEntity::getDownloader, (Object)downloader));
    }

    @Override
    public void flushToDatabase(BatchHandleTasks t) {
        TorrentWrapper torrent = t.torrent;
        PeerWrapper peer = t.peer;
        String downloader = t.downloader;
        OffsetDateTime timestamp = t.timestamp;
        TorrentEntity torrentEntity = this.torrentDao.createIfNotExists(new TorrentEntity(null, torrent.getHash(), torrent.getName(), torrent.getSize(), torrent.isPrivateTorrent()));
        InetAddress inet = peer.getAddress().getAddress().toInetAddress();
        LazyLoad<IPGeoData> lazyLoader = this.ipdbManager.queryIPDB(inet).geoData();
        IPGeoData peerGeoIp = lazyLoader.get();
        ((PeerRecordMapper)this.baseMapper).upsert(new PeerRecordEntity(null, inet, peer.toPeerAddress().getPort(), torrentEntity.getId(), downloader, peer.getId().length() > 8 ? peer.getId().substring(0, 8) : peer.getId(), peer.getClientName(), peer.getUploaded(), peer.getUploaded(), peer.getUploadSpeed(), peer.getDownloaded(), peer.getDownloaded(), peer.getDownloadSpeed(), peer.getFlags(), timestamp, timestamp, peerGeoIp));
    }

    @Override
    public long sessionBetween(@NotNull String downloader, @NotNull OffsetDateTime startAt, @NotNull OffsetDateTime endAt) {
        return ((PeerRecordMapper)this.baseMapper).sessionBetween(downloader, startAt, endAt);
    }

    @Override
    public Page<PeerRecordEntity> getPendingSubmitPeerRecords(@NotNull Pageable pageable, @NotNull OffsetDateTime afterThan) {
        return (Page)((PeerRecordMapper)this.baseMapper).selectPage((IPage)pageable.toPage(), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().gt(PeerRecordEntity::getLastTimeSeen, (Object)afterThan)).or()).isNull(PeerRecordEntity::getLastTimeSeen)).orderByAsc(PeerRecordEntity::getLastTimeSeen));
    }

    @Override
    public long countRecordsByIp(@NotNull InetAddress inetAddress) {
        return ((PeerRecordMapper)this.baseMapper).selectCount((Wrapper)new LambdaQueryWrapper().eq(PeerRecordEntity::getAddress, (Object)inetAddress));
    }

    @Override
    public IPAddressTotalTraffic queryAddressTotalTraffic(@NotNull InetAddress inet) {
        IPAddressTotalTraffic traffic = ((PeerRecordMapper)this.baseMapper).queryAddressTotalTraffic(inet);
        if (traffic == null) {
            traffic = new IPAddressTotalTraffic();
            traffic.setTotalUploaded(-1L);
            traffic.setTotalDownloaded(-1L);
        }
        return traffic;
    }

    @Override
    public IPAddressTimeSeen queryAddressTimeSeen(@NotNull InetAddress inet) {
        IPAddressTimeSeen timeSeen = ((PeerRecordMapper)this.baseMapper).queryAddressTimeSeen(inet);
        if (timeSeen == null) {
            timeSeen = new IPAddressTimeSeen();
            timeSeen.setFirstTimeSeen(TimeUtil.zeroOffsetDateTime);
            timeSeen.setLastTimeSeen(TimeUtil.zeroOffsetDateTime);
        }
        return timeSeen;
    }

    @NotNull
    public Page<PeerRecordEntity> queryAccessHistoryByIp(@NotNull Page<PeerRecordEntity> page, @NotNull InetAddress ip, @NotNull Orderable orderable) {
        return ((PeerRecordMapper)this.baseMapper).queryAccessHistoryByIp(page, ip, orderable.generateOrderBy());
    }

    @Override
    @NotNull
    public Page<ClientAnalyseResult> queryClientAnalyse(@NotNull Page<ClientAnalyseResult> page, @NotNull OffsetDateTime startAt, @NotNull OffsetDateTime endAt, @Nullable String downloader, @NotNull String orderBySql) {
        return ((PeerRecordMapper)this.baseMapper).queryClientAnalyse(page, startAt, endAt, downloader, orderBySql);
    }

    @Override
    public long countRecordsByTorrentId(Long id) {
        return ((PeerRecordMapper)this.baseMapper).selectCount((Wrapper)new LambdaQueryWrapper().eq(PeerRecordEntity::getTorrentId, (Object)id));
    }

    @Override
    @NotNull
    public Page<PeerRecordEntity> queryAccessHistoryByTorrentId(@NotNull Page<PeerRecordEntity> page, @NotNull Long id, @NotNull Orderable orderable) {
        return (Page)((PeerRecordMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)orderable.apply((QueryWrapper)new QueryWrapper().eq((Object)"torrent_id", (Object)id)));
    }

    @Override
    public Map<Long, Long> countByTorrentIds(@NotNull List<Long> torrentIds) {
        if (torrentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TorrentCount> counts = ((PeerRecordMapper)this.baseMapper).countByTorrentIds(torrentIds);
        return counts.stream().collect(Collectors.toMap(TorrentCount::getTorrentId, TorrentCount::getCount));
    }

    @Override
    public List<String> getDistinctIps(@NotNull OffsetDateTime startAt, @NotNull OffsetDateTime endAt, @Nullable String downloader) {
        return ((PeerRecordMapper)this.baseMapper).getDistinctIps(startAt, endAt, downloader);
    }

    @Override
    public long cleanup(@NotNull OffsetDateTime before) {
        return this.splitBatchDelete((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PeerRecordEntity::getId}).lt(PeerRecordEntity::getLastTimeSeen, (Object)before));
    }

    public record BatchHandleTasks(OffsetDateTime timestamp, String downloader, TorrentWrapper torrent, PeerWrapper peer) {
    }
}

