/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.event.program.PBHServerStartedEvent;
import com.ghostchu.peerbanhelper.gui.PBHGuiBridge;
import com.ghostchu.peerbanhelper.gui.impl.swing.SwingTray;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.SwingMainWindow;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.google.common.eventbus.Subscribe;
import io.sentry.Sentry;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

public class TrayMenu {
    private final SwingMainWindow parent;
    private boolean persistFlagTrayMessageSent;
    @Nullable
    private SwingTray swingTrayDialog;
    private PBHGuiBridge bridge;

    public TrayMenu(SwingMainWindow parent) {
        this.parent = parent;
        this.setupSystemTray();
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onPeerBanHelperStarted(PBHServerStartedEvent event) {
        this.bridge = (PBHGuiBridge)Main.getApplicationContext().getBean(PBHGuiBridge.class);
        SwingUtilities.invokeLater(this::updateTrayMenus);
    }

    private void setupSystemTray() {
        if (SystemTray.isSupported()) {
            TrayIcon icon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/assets/icon.png")));
            icon.setImageAutoSize(true);
            SystemTray sysTray = SystemTray.getSystemTray();
            try {
                SwingTray tray = new SwingTray(icon, mouseEvent -> this.parent.setVisible(true), mouseEvent -> this.updateTrayMenus());
                sysTray.add(icon);
                this.updateTrayMenus();
                this.swingTrayDialog = tray;
            }
            catch (AWTException e) {
                Sentry.captureException((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void minimizeToTray() {
        if (this.swingTrayDialog != null) {
            this.parent.setVisible(false);
            if (!this.persistFlagTrayMessageSent) {
                this.persistFlagTrayMessageSent = true;
                if (!ExternalSwitch.parseBoolean("pbh.gui.hide-tray-message", false)) {
                    this.parent.getSwingGUI().createNotification(Level.INFO, TextManager.tlUI(Lang.GUI_TRAY_MESSAGE_CAPTION, new Object[0]), TextManager.tlUI(Lang.GUI_TRAY_MESSAGE_DESCRIPTION, new Object[0]));
                }
            }
        }
    }

    private void updateTrayMenus() {
        if (this.swingTrayDialog == null) {
            return;
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem openMainWindow = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_SHOW_WINDOW, new Object[0]), (Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/tray/open.svg")));
        JMenuItem openWebUI = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_WEBUI_OPEN, new Object[0]), (Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/tray/browser.svg")));
        JMenuItem quit = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_QUIT, new Object[0]), (Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/tray/close.svg")));
        openMainWindow.addActionListener(e -> this.parent.setVisible(true));
        openWebUI.addActionListener(e -> this.parent.openWebUI());
        quit.addActionListener(e -> System.exit(0));
        items.add(this.menuDisplayItem(new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_STATS, new Object[0]))));
        items.add(this.menuBanStats());
        items.add(this.menuDownloaderStats());
        items.add(this.menuDisplayItem(new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_QUICK_OPERATIONS, new Object[0]))));
        items.add(openMainWindow);
        items.add(openWebUI);
        items.add(null);
        items.add(quit);
        this.swingTrayDialog.set(items);
    }

    private JMenuItem menuDownloaderStats() {
        long totalDownloaders = 0L;
        long healthDownloaders = 0L;
        if (Main.getServer() != null) {
            totalDownloaders = Main.getServer().getDownloaderManager().getDownloaders().size();
            healthDownloaders = Main.getServer().getDownloaderManager().getDownloaders().stream().filter(m -> m.getLastStatus() == DownloaderLastStatus.HEALTHY).count();
        }
        return new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_STATS_DOWNLOADER, healthDownloaders, totalDownloaders), (Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/tray/connection.svg")));
    }

    private JMenuItem menuBanStats() {
        long bannedPeers = 0L;
        long bannedIps = 0L;
        PeerBanHelper server = Main.getServer();
        if (server != null) {
            bannedIps = Main.getServer().getDownloaderServer().getBanList().copyKeySet().stream().distinct().count();
            bannedPeers = Main.getServer().getDownloaderServer().getBanList().size();
        }
        return new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_STATS_BANNED, bannedPeers, bannedIps), (Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/tray/banned.svg")));
    }

    private JMenuItem menuDisplayItem(JMenuItem jMenuItem) {
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    @Nullable
    @Generated
    public SwingTray getSwingTrayDialog() {
        return this.swingTrayDialog;
    }
}

