/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleMatchResult;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import io.sentry.Sentry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PTRBlacklist
extends AbstractRuleFeatureModule
implements Reloadable {
    private List<Rule> ptrRules;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private DNSLookup dnsLookup;
    private long banDuration;
    @Autowired
    private Laboratory laboratory;

    @Override
    @NotNull
    public String getName() {
        return "PTR Blacklist";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "ptr-blacklist";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.webContainer.javalin().get("/api/modules/" + this.getConfigName(), this::handleWebAPI, new RouteRole[]{Role.USER_READ});
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    private void handleWebAPI(Context ctx) {
        String locale = this.locale(ctx);
        ctx.json((Object)new StdResp(true, null, Map.of("ptr-rules", this.ptrRules.stream().map(r -> r.toPrintableText(locale)).toList())));
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    public void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.ptrRules = RuleParser.parse(this.getConfig().getStringList("ptr-rules"));
        this.getCache().invalidateAll();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        String reverseDnsLookupString = peer.getPeerAddress().getAddress().toReverseDNSLookupString();
        return this.getCache().readCache(this, reverseDnsLookupString, () -> {
            RuleMatchResult matchResult;
            Optional<Object> ptr;
            try {
                ptr = this.dnsLookup.ptr(reverseDnsLookupString).get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                ptr = Optional.empty();
                Sentry.captureException((Throwable)e);
            }
            if (ptr.isPresent() && (matchResult = RuleParser.matchRule(this.ptrRules, (String)ptr.get())).hit()) {
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, matchResult.rule().matcherName(), new TranslationComponent(Lang.MODULE_PTR_MATCH_PTR_RULE, matchResult.rule().matcherName()), StructuredData.create().add("rule", matchResult.rule().metadata()));
            }
            return this.pass();
        }, true);
    }
}

