/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.databasent.dto.ClientAnalyseResult;
import com.ghostchu.peerbanhelper.databasent.dto.TrafficDataComputed;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsService;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.service.TrafficJournalService;
import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.databasent.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerConnectionMetricsDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleOffsetDateTimeIntKVDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleStringIntKVDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDB;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.PBHPage;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHChartController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHChartController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private PeerRecordService peerRecordService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TrafficJournalService trafficJournalDao;
    @Autowired
    private IPDBManager iPDBManager;
    @Autowired
    private PeerConnectionMetricsService peerConnectionMetricDao;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Charts";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-charts";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/chart/geoIpInfo", this::handleGeoIP, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/trend", this::handlePeerTrends, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/traffic", this::handleTrafficClassic, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionBetween", this::handleSessionBetween, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionDayBucket", this::handleSessionDayBucket, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionAnalyse", this::handleSessionAnalyse, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/clientAnalyse", this::handleClientAnalyse, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS});
    }

    private void handleClientAnalyse(@NotNull Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        Pageable pageable = new Pageable(ctx);
        Orderable orderable = new Orderable(Map.of("uploaded", false), ctx);
        Page<ClientAnalyseResult> dtoPage = this.peerRecordService.queryClientAnalyse(pageable.toPage(), timeQueryModel.startAt(), timeQueryModel.endAt(), downloader, orderable.generateOrderBy());
        ctx.json((Object)new StdResp(true, null, PBHPage.from(dtoPage)));
    }

    private void handleSessionAnalyse(@NotNull Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        List<PeerConnectionMetricsDTO> data = this.peerConnectionMetricDao.getMetricsSince(timeQueryModel.startAt(), timeQueryModel.endAt(), downloader);
        ctx.json((Object)new StdResp(true, null, data));
    }

    private void handleSessionBetween(@NotNull Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        if (downloader == null || downloader.isBlank()) {
            downloader = "%";
        }
        ctx.json((Object)new StdResp(true, null, this.peerRecordService.sessionBetween(downloader, timeQueryModel.startAt(), timeQueryModel.endAt())));
    }

    private void handleSessionDayBucket(@NotNull Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        long startAtTs = timeQueryModel.startAt().toInstant().toEpochMilli();
        long endAtTs = timeQueryModel.endAt().toInstant().toEpochMilli();
        LinkedHashMap<Long, SessionTimeRangeCounter> sessionDayBucket = new LinkedHashMap<Long, SessionTimeRangeCounter>();
        List<PeerRecordEntity> peerRecords = this.peerRecordService.getRecordsBetween(timeQueryModel.startAt(), timeQueryModel.endAt(), downloader);
        for (PeerRecordEntity record : peerRecords) {
            long firstDay = TimeUtil.getStartOfToday(record.getFirstTimeSeen()).toInstant().toEpochMilli();
            long lastDay = TimeUtil.getStartOfToday(record.getLastTimeSeen()).toInstant().toEpochMilli();
            for (long day = firstDay; day <= lastDay; day += 86400000L) {
                if (day < startAtTs || day > endAtTs) continue;
                SessionTimeRangeCounter counter = sessionDayBucket.computeIfAbsent(day, k -> new SessionTimeRangeCounter());
                counter.getTotal().incrementAndGet();
                if (record.getLastFlags() == null || record.getLastFlags().isBlank() || new PeerFlag(record.getLastFlags()).isLocalConnection()) continue;
                counter.getIncoming().incrementAndGet();
            }
        }
        ctx.json((Object)new StdResp(true, null, sessionDayBucket.entrySet().stream().map(e -> new SessionDayBucketDTO((Long)e.getKey(), ((SessionTimeRangeCounter)e.getValue()).total.intValue(), ((SessionTimeRangeCounter)e.getValue()).incoming.intValue())).sorted(Comparator.comparingLong(SessionDayBucketDTO::key)).toList()));
    }

    private void handleTrafficClassic(Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        List<TrafficDataComputed> records = this.trafficJournalDao.getDayOffsetData(downloader, timeQueryModel.startAt(), timeQueryModel.endAt());
        HashMap<OffsetDateTime, TrafficDataComputed> mergedData = new HashMap<OffsetDateTime, TrafficDataComputed>();
        for (TrafficDataComputed record : records) {
            OffsetDateTime ts = record.getTimestamp();
            OffsetDateTime dayStart = TimeUtil.getStartOfToday(ts);
            mergedData.compute(dayStart, (key, existing) -> {
                if (existing == null) {
                    return new TrafficDataComputed((OffsetDateTime)key, record.getDataOverallUploaded(), record.getDataOverallDownloaded());
                }
                existing.setDataOverallUploaded(existing.getDataOverallUploaded() + record.getDataOverallUploaded());
                existing.setDataOverallDownloaded(existing.getDataOverallDownloaded() + record.getDataOverallDownloaded());
                return existing;
            });
        }
        ArrayList mergedRecords = new ArrayList(mergedData.values());
        mergedRecords.sort(Comparator.comparing(TrafficDataComputed::getTimestamp));
        ctx.json((Object)new StdResp(true, null, mergedRecords));
    }

    private void handlePeerTrends(Context ctx) {
        String downloader = ctx.queryParam("downloader");
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap connectedPeerTrends = new ConcurrentHashMap();
        ConcurrentHashMap bannedPeerTrends = new ConcurrentHashMap();
        LambdaQueryWrapper queryConnected = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{PeerRecordEntity::getId, PeerRecordEntity::getLastTimeSeen}).ge(PeerRecordEntity::getLastTimeSeen, (Object)timeQueryModel.startAt())).le(PeerRecordEntity::getLastTimeSeen, (Object)timeQueryModel.endAt());
        LambdaQueryWrapper queryBanned = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{HistoryEntity::getId, HistoryEntity::getBanAt}).ge(HistoryEntity::getBanAt, (Object)timeQueryModel.startAt())).le(HistoryEntity::getBanAt, (Object)timeQueryModel.endAt());
        if (downloader != null && !downloader.isBlank()) {
            queryConnected.eq(PeerRecordEntity::getDownloader, (Object)downloader);
            queryBanned.eq(HistoryEntity::getDownloader, (Object)downloader);
        }
        this.peerRecordService.list((Wrapper)queryConnected).forEach(entity -> {
            OffsetDateTime startOfDay = TimeUtil.getStartOfToday(entity.getLastTimeSeen());
            connectedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
        });
        this.historyService.list((Wrapper)queryBanned).forEach(entity -> {
            OffsetDateTime startOfDay = TimeUtil.getStartOfToday(entity.getBanAt());
            bannedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
        });
        ctx.json((Object)new StdResp(true, null, Map.of("connectedPeersTrend", connectedPeerTrends.entrySet().stream().map(e -> new SimpleOffsetDateTimeIntKVDTO((OffsetDateTime)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparing(SimpleOffsetDateTimeIntKVDTO::key)).toList(), "bannedPeersTrend", bannedPeerTrends.entrySet().stream().map(e -> new SimpleOffsetDateTimeIntKVDTO((OffsetDateTime)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparing(SimpleOffsetDateTimeIntKVDTO::key)).toList())));
    }

    private void handleGeoIP(Context ctx) {
        IPDB ipdb = this.iPDBManager.getIpdb();
        if (ipdb == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.CHARTS_IPDB_NEED_INIT, new Object[0]), null));
            return;
        }
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        boolean bannedOnly = Boolean.parseBoolean(ctx.queryParam("bannedOnly"));
        String downloader = ctx.queryParam("downloader");
        ConcurrentHashMap ispCounter = new ConcurrentHashMap();
        ConcurrentHashMap cnProvinceCounter = new ConcurrentHashMap();
        ConcurrentHashMap cnCityCounter = new ConcurrentHashMap();
        ConcurrentHashMap countryOrRegionCounter = new ConcurrentHashMap();
        ConcurrentHashMap netTypeCounter = new ConcurrentHashMap();
        List<String> ips = bannedOnly ? this.historyService.getDistinctIps(timeQueryModel.startAt(), timeQueryModel.endAt(), downloader) : this.peerRecordService.getDistinctIps(timeQueryModel.startAt(), timeQueryModel.endAt(), downloader);
        try (ExecutorService service = Executors.newWorkStealingPool();){
            for (String ip : ips) {
                if (ip == null || ip.isBlank()) continue;
                service.submit(() -> {
                    try {
                        String determindIp = ip;
                        if (IPAddressUtil.getIPAddress(determindIp).isPrefixed()) {
                            determindIp = IPAddressUtil.getIPAddress(determindIp).toPrefixBlock().getLower().withoutPrefixLength().toNormalizedString();
                        }
                        IPGeoData ipGeoData = ipdb.query(InetAddress.getByName(determindIp));
                        String isp = "N/A";
                        if (ipGeoData.getAs() != null) {
                            isp = ipGeoData.getAs().getOrganization();
                        }
                        String countryOrRegion = "N/A";
                        String province = "N/A";
                        Object city = "N/A";
                        String netType = "N/A";
                        if (ipGeoData.getCountry() != null) {
                            countryOrRegion = ipGeoData.getCountry().getName();
                        }
                        if (ipGeoData.getCity() != null) {
                            city = ipGeoData.getCity().getName();
                            if (ipGeoData.getCity().getCnProvince() != null) {
                                province = ipGeoData.getCity().getCnProvince();
                            }
                            if (ipGeoData.getCity().getCnCity() != null) {
                                city = ipGeoData.getCity().getCnProvince() + " " + ipGeoData.getCity().getCnCity();
                            }
                        }
                        if (ipGeoData.getNetwork() != null) {
                            isp = ipGeoData.getNetwork().getIsp();
                            netType = ipGeoData.getNetwork().getNetType();
                        }
                        ispCounter.computeIfAbsent(isp, k -> new AtomicInteger()).incrementAndGet();
                        cnProvinceCounter.computeIfAbsent(province, k -> new AtomicInteger()).incrementAndGet();
                        cnCityCounter.computeIfAbsent(city, k -> new AtomicInteger()).incrementAndGet();
                        countryOrRegionCounter.computeIfAbsent(countryOrRegion, k -> new AtomicInteger()).incrementAndGet();
                        netTypeCounter.computeIfAbsent(netType, k -> new AtomicInteger()).incrementAndGet();
                    }
                    catch (UnknownHostException e) {
                        log.error("Unable to resolve the GeoIP data for ip {}", (Object)ip, (Object)e);
                    }
                });
            }
        }
        ctx.json((Object)new StdResp(true, null, Map.of("isp", ispCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "province", cnProvinceCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "region", countryOrRegionCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "city", cnCityCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList())));
    }

    @Override
    public void onDisable() {
    }

    private static class SessionTimeRangeCounter {
        private final AtomicInteger total = new AtomicInteger(0);
        private final AtomicInteger incoming = new AtomicInteger(0);

        private SessionTimeRangeCounter() {
        }

        @Generated
        public AtomicInteger getTotal() {
            return this.total;
        }

        @Generated
        public AtomicInteger getIncoming() {
            return this.incoming;
        }
    }

    public record SessionDayBucketDTO(long key, long total, long incoming) {
    }
}

