/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.databasent.dto.UniversalFieldDateResult;
import com.ghostchu.peerbanhelper.databasent.dto.UniversalFieldNumResult;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsService;
import com.ghostchu.peerbanhelper.databasent.service.TrackedSwarmService;
import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleOffsetDateTimeIntKVDTO;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class PBHMetricsController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHMetricsController.class);
    @Autowired
    @Qualifier(value="persistMetrics")
    private BasicMetrics metrics;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private TrackedSwarmService trackedSwarmDao;
    @Autowired
    private PeerConnectionMetricsService peerConnectionMetricDao;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/statistic/counter", this::handleBasicCounter, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/field", this::handleHistoryNumberAccess, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/banTrends", this::handleBanTrends, new RouteRole[]{Role.USER_READ})).get("/api/statistic/analysis/date", this::handleHistoryDateAccess, new RouteRole[]{Role.USER_READ});
    }

    private void handleBanTrends(Context ctx) {
        String downloader = ctx.queryParam("downloader");
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap bannedPeerTrends = new ConcurrentHashMap();
        LambdaQueryWrapper queryBanned = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{HistoryEntity::getId, HistoryEntity::getBanAt}).ge(HistoryEntity::getBanAt, (Object)timeQueryModel.startAt())).le(HistoryEntity::getBanAt, (Object)timeQueryModel.endAt());
        if (downloader != null && !downloader.isBlank()) {
            queryBanned.eq(HistoryEntity::getDownloader, (Object)downloader);
        }
        this.historyService.list((Wrapper)queryBanned).forEach(entity -> {
            OffsetDateTime startOfDay = TimeUtil.getStartOfToday(entity.getBanAt());
            bannedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
        });
        ctx.json((Object)new StdResp(true, null, bannedPeerTrends.entrySet().stream().map(e -> new SimpleOffsetDateTimeIntKVDTO((OffsetDateTime)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparing(SimpleOffsetDateTimeIntKVDTO::key)).toList()));
    }

    private void handleHistoryDateAccess(Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String filter = Objects.requireNonNullElse(ctx.queryParam("filter"), "0.0");
        String type = ctx.queryParam("type");
        String field = ctx.queryParam("field");
        if (field == null) {
            throw new IllegalArgumentException("startAt cannot be null");
        }
        if ("banAt".equalsIgnoreCase(field) && "day".equals(type)) {
            this.handlePeerBans(ctx);
            return;
        }
        String string = type;
        int n = 0;
        Function<Calendar, Calendar> trimmer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"year", "month", "day", "hour", "minute", "second"}, (String)string, n)) {
            case 0 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                return calendar;
            };
            case 1 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                return calendar;
            };
            case 2 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                return calendar;
            };
            case 3 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                return calendar;
            };
            case 4 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                calendar.set(12, time.get(12));
                return calendar;
            };
            case 5 -> time -> {
                Calendar calendar = this.getZeroCalender();
                calendar.set(1, time.get(1));
                calendar.set(2, time.get(2));
                calendar.set(5, time.get(5));
                calendar.set(11, time.get(11));
                calendar.set(12, time.get(12));
                calendar.set(13, time.get(13));
                return calendar;
            };
            default -> throw new IllegalArgumentException("Unexpected value: " + type);
        };
        String string2 = field;
        int n2 = 0;
        Function<HistoryEntity, OffsetDateTime> timestampGetter = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"banAt", "unbanAt"}, (String)string2, n2)) {
            case 0 -> HistoryEntity::getBanAt;
            case 1 -> HistoryEntity::getUnbanAt;
            default -> throw new IllegalArgumentException("Unexpected value: " + field);
        };
        double pctFilter = Double.parseDouble(filter);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{HistoryEntity::getBanAt, HistoryEntity::getUnbanAt}).ge(HistoryEntity::getBanAt, (Object)timeQueryModel.startAt())).le(HistoryEntity::getBanAt, (Object)timeQueryModel.endAt());
        List entities = this.historyService.list((Wrapper)query);
        HashMap<Long, AtomicInteger> map = new HashMap<Long, AtomicInteger>();
        for (HistoryEntity entity : entities) {
            OffsetDateTime time2 = timestampGetter.apply(entity);
            if (time2 == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(time2.toInstant().toEpochMilli());
            Calendar trimmed = trimmer.apply(cal);
            map.computeIfAbsent(trimmed.getTimeInMillis(), k -> new AtomicInteger()).incrementAndGet();
        }
        long total = map.values().stream().mapToLong(AtomicInteger::get).sum();
        ArrayList<UniversalFieldDateResult> results = new ArrayList<UniversalFieldDateResult>();
        for (Map.Entry entry : map.entrySet()) {
            double pct = (double)((AtomicInteger)entry.getValue()).get() / (double)total;
            if (!(pct >= pctFilter)) continue;
            results.add(new UniversalFieldDateResult((Long)entry.getKey(), ((AtomicInteger)entry.getValue()).get(), pct));
        }
        ctx.json((Object)new StdResp(true, null, results));
    }

    private Calendar getZeroCalender() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private void handleHistoryNumberAccess(Context ctx) {
        String type = ctx.queryParam("type");
        String field = ctx.queryParam("field");
        double filter = Double.parseDouble(Objects.requireNonNullElse(ctx.queryParam("filter"), "0.0"));
        String downloader = ctx.queryParam("downloader");
        Integer substringLength = null;
        if ("peerId".equalsIgnoreCase(field) || "peer_id".equalsIgnoreCase(field)) {
            substringLength = 8;
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        String string = type;
        int n = 0;
        List<UniversalFieldNumResult> results = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"count", "sum"}, (String)string, n)) {
            case 0 -> this.historyService.countField(field, filter, downloader, substringLength);
            case 1 -> this.historyService.sumField(field, filter, downloader, substringLength);
            default -> throw new IllegalArgumentException("type invalid");
        };
        ctx.json((Object)new StdResp(true, null, results));
    }

    private void handlePeerBans(Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap bannedPeerTrends = new ConcurrentHashMap();
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{HistoryEntity::getId, HistoryEntity::getBanAt}).ge(HistoryEntity::getBanAt, (Object)timeQueryModel.startAt())).le(HistoryEntity::getBanAt, (Object)timeQueryModel.endAt());
        this.historyService.list((Wrapper)query).forEach(entity -> {
            OffsetDateTime startOfDay = TimeUtil.getStartOfToday(entity.getBanAt());
            bannedPeerTrends.computeIfAbsent(startOfDay.toInstant().toEpochMilli(), k -> new AtomicInteger()).addAndGet(1);
        });
        ctx.json((Object)new StdResp(true, null, bannedPeerTrends.entrySet().stream().map(e -> new UniversalFieldDateResult((Long)e.getKey(), ((AtomicInteger)e.getValue()).intValue(), 0.0)).toList()));
    }

    private void handleBasicCounter(Context ctx) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("checkCounter", this.metrics.getCheckCounter());
        map.put("peerBanCounter", this.metrics.getPeerBanCounter());
        map.put("peerUnbanCounter", this.metrics.getPeerUnbanCounter());
        map.put("banlistCounter", this.downloaderServer.getBanList().size());
        map.put("bannedIpCounter", this.downloaderServer.getBanList().copyKeySet().stream().distinct().count());
        map.put("wastedTraffic", this.metrics.getWastedTraffic());
        try {
            long trackedPeers = this.trackedSwarmDao.count();
            map.put("trackedSwarmCount", trackedPeers);
            if (trackedPeers > 0L) {
                map.put("peersBlockRate", (double)this.metrics.getPeerBanCounter() / (double)trackedPeers);
            } else {
                map.put("peersBlockRate", 0.0);
            }
        }
        catch (Exception e) {
            map.put("peersBlockRate", 0.0);
            log.error("Unable to query tracked swarm count", (Throwable)e);
        }
        OffsetDateTime startWeekly = TimeUtil.getStartOfToday(System.currentTimeMillis() - 604800000L);
        OffsetDateTime endToday = TimeUtil.getStartOfToday(System.currentTimeMillis());
        map.put("weeklySessions", this.peerConnectionMetricDao.getGlobalTotalConnectionsCount(startWeekly, endToday));
        ctx.json((Object)new StdResp(true, null, map));
    }

    @Override
    public void onDisable() {
        this.metrics = null;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Metrics";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-metrics";
    }
}

