/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.h2.H2DatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.mysql.MySQLDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.postgres.PostgresDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.sqlite.SQLiteDatabaseDriver;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.DatabaseNtConfigDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.ReloadEntryDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.DownloaderDiscovery;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.MemoryConfiguration;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHOOBEController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHOOBEController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private DownloaderManagerImpl downloaderManager;
    @Autowired
    private DownloaderDiscovery downloaderDiscovery;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - OOBE Interface";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-oobe";
    }

    @Override
    public void onEnable() {
        if (this.isInitialized(null)) {
            return;
        }
        ((Javalin)((Javalin)((Javalin)this.webContainer.javalin().post("/api/oobe/init", this::handleOOBERequest, new RouteRole[]{Role.ANYONE})).post("/api/oobe/scanDownloader", this::handleOOBEScanDownloader, new RouteRole[]{Role.ANYONE})).post("/api/oobe/testDownloader", ctx -> this.validateDownloader(ctx, JsonParser.parseString((String)ctx.body()).getAsJsonObject()), new RouteRole[]{Role.ANYONE})).post("/api/oobe/testDatabaseConfig", this::handleDatabaseNtTest, new RouteRole[]{Role.ANYONE});
    }

    private void handleOOBEScanDownloader(@NotNull Context ctx) {
        if (this.isInitialized(ctx)) {
            return;
        }
        List<DownloaderDiscovery.DiscoveredDownloader> downloaders = this.downloaderDiscovery.scan(List.of()).join();
        ctx.json((Object)new StdResp(true, null, downloaders));
    }

    private void handleOOBERequest(Context ctx) throws IOException {
        if (this.isInitialized(ctx)) {
            return;
        }
        JsonObject parser = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        String token = parser.get("token").getAsString();
        JsonObject draftDownloader = parser.get("downloader").getAsJsonObject();
        if (!this.validateDownloader(ctx, draftDownloader)) {
            return;
        }
        YamlConfiguration conf = Main.getMainConfig();
        conf.set("server.token", (Object)token);
        conf.save(Main.getMainConfigFile());
        this.webContainer.setToken(token);
        JsonObject config = draftDownloader.get("config").getAsJsonObject();
        String id = draftDownloader.get("id").getAsString();
        Downloader downloader = this.downloaderManager.createDownloader(id, config);
        if (this.downloaderManager.registerDownloader(downloader)) {
            ctx.status(HttpStatus.CREATED);
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATED, new Object[0]), null));
        } else {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATION_FAILED_ALREADY_EXISTS, new Object[0]), null));
        }
        try {
            this.downloaderManager.saveDownloaders();
        }
        catch (IOException e) {
            log.error("Internal server error, unable to create downloader due an I/O exception", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATION_FAILED_IO_EXCEPTION, new Object[0]), null));
        }
        JsonObject btn = parser.getAsJsonObject("btn");
        if (btn != null) {
            if (btn.has("enabled") && !btn.get("enabled").isJsonNull()) {
                conf.set("btn.enabled", (Object)btn.get("enabled").getAsBoolean());
            }
            if (btn.has("submit") && !btn.get("submit").isJsonNull()) {
                conf.set("btn.submit", (Object)btn.get("submit").getAsBoolean());
            }
            if (btn.has("app_id") && !btn.get("app_id").isJsonNull()) {
                conf.set("btn.app-id", (Object)btn.get("app_id").getAsString());
            }
            if (btn.has("app_secret") && !btn.get("app_secret").isJsonNull()) {
                conf.set("btn.app-secret", (Object)btn.get("app_secret").getAsString());
            }
            conf.save(Main.getMainConfigFile());
        }
        if (parser.has("database")) {
            JsonObject database = parser.get("database").getAsJsonObject();
            boolean needRestart = false;
            String type = null;
            if (database.has("type")) {
                type = database.get("type").getAsString();
                conf.set("database.type", (Object)type);
                if (!"sqlite".equals(type)) {
                    needRestart = true;
                }
            }
            if ("mysql".equals(type) || "postgresql".equals(type)) {
                if (database.has("host")) {
                    conf.set("database.host", (Object)database.get("host").getAsString());
                }
                if (database.has("port")) {
                    conf.set("database.port", (Object)database.get("port").getAsInt());
                }
                if (database.has("database")) {
                    conf.set("database.database", (Object)database.get("database").getAsString());
                }
                if (database.has("username")) {
                    conf.set("database.username", (Object)database.get("username").getAsString());
                }
                if (database.has("password")) {
                    conf.set("database.password", (Object)database.get("password").getAsString());
                }
            }
            conf.save(Main.getMainConfigFile());
            if (needRestart) {
                this.handleRestart(ctx);
            }
        }
        this.handleReloading(ctx);
    }

    private void handleReloading(Context context) {
        Map result = Main.getReloadManager().reload();
        ArrayList entryList = new ArrayList();
        result.forEach((container, r) -> {
            Reloadable reloadable;
            Object entryName = container.getReloadable() == null ? container.getReloadableMethod().getDeclaringClass().getName() + "#" + container.getReloadableMethod().getName() : ((reloadable = (Reloadable)container.getReloadable().get()) == null ? "<invalid>" : reloadable.getClass().getName());
            entryList.add(new ReloadEntryDTO((String)entryName, r.getStatus().name()));
        });
        boolean success = true;
        TranslationComponent message = new TranslationComponent(Lang.RELOAD_RESULT_SUCCESS);
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.SCHEDULED)) {
            message = new TranslationComponent(Lang.RELOAD_RESULT_SCHEDULED);
        }
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.REQUIRE_RESTART)) {
            message = new TranslationComponent(Lang.RELOAD_RESULT_REQUIRE_RESTART);
        }
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.EXCEPTION)) {
            success = false;
            message = new TranslationComponent(Lang.RELOAD_RESULT_FAILED);
        }
        context.json((Object)new StdResp(success, TextManager.tl(this.locale(context), message), entryList));
    }

    private void handleRestart(Context context) {
        if (this.isInitialized(context)) {
            return;
        }
        context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), Lang.RELOAD_RESULT_REQUIRE_RESTART, new Object[0]), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDatabaseNtTest(@NotNull Context context) {
        if (this.isInitialized(context)) {
            return;
        }
        DatabaseNtConfigDTO dto = (DatabaseNtConfigDTO)context.bodyAsClass(DatabaseNtConfigDTO.class);
        MemoryConfiguration section = new MemoryConfiguration();
        section.set("type", (Object)dto.getType());
        section.set("host", (Object)dto.getHost());
        section.set("port", (Object)dto.getPort());
        section.set("username", (Object)dto.getUsername());
        section.set("password", (Object)dto.getPassword());
        section.set("database", (Object)dto.getDatabase());
        try {
            AbstractDatabaseDriver abstractDatabaseDriver = switch (dto.getType()) {
                case "h2" -> new H2DatabaseDriver((ConfigurationSection)section);
                case "mysql" -> new MySQLDatabaseDriver((ConfigurationSection)section);
                case "postgresql" -> new PostgresDatabaseDriver((ConfigurationSection)section);
                default -> new SQLiteDatabaseDriver((ConfigurationSection)section);
            };
            try (AbstractDatabaseDriver driver = abstractDatabaseDriver;
                 Statement stat = driver.getDataSource().getConnection().createStatement();){
                boolean success = stat.execute("SELECT 1");
                context.json((Object)new StdResp(true, null, success));
            }
        }
        catch (Exception e) {
            context.status(HttpStatus.BAD_REQUEST);
            context.json((Object)new StdResp(false, e.getClass().getName() + ": " + e.getMessage(), null));
        }
    }

    public boolean validateDownloader(Context ctx, JsonObject draftDownloader) {
        if (this.isInitialized(ctx)) {
            return false;
        }
        JsonObject config = draftDownloader.get("config").getAsJsonObject();
        String id = draftDownloader.get("id").getAsString();
        Downloader downloader = this.downloaderManager.createDownloader(id, config);
        if (downloader == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_ADD_FAILURE, new Object[0]), null));
            return false;
        }
        try {
            DownloaderLoginResult testResult = downloader.login();
            if (testResult.success()) {
                ctx.json((Object)new StdResp(testResult.success(), TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_TEST_OK, new Object[0]), null));
            } else {
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), testResult.message()), null));
            }
            downloader.close();
            return true;
        }
        catch (Exception e) {
            log.error("Validate downloader failed", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, e.getMessage(), null));
            return false;
        }
    }

    private boolean isInitialized(@Nullable Context ctx) {
        if (this.webContainer.getToken() != null && !this.webContainer.getToken().isBlank()) {
            if (ctx != null) {
                ctx.status(HttpStatus.FORBIDDEN);
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.OOBE_DISALLOW_REINIT, new Object[0]), null));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onDisable() {
    }
}

