/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus.backend;

import com.ghostchu.peerbanhelper.pbhplus.backend.LicenseBackend;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.data.LicenseStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class BasicLicenseBackend
implements LicenseBackend {
    protected final Map<String, License> licenses = Collections.synchronizedMap(new LinkedHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLicenses(@NotNull Map<String, License> in) {
        Map<String, License> map = this.licenses;
        synchronized (map) {
            this.licenses.clear();
            this.licenses.putAll(in);
        }
    }

    @Override
    @NotNull
    public Map<String, License> getLicensesMap() {
        return Collections.unmodifiableMap(this.licenses);
    }

    @Override
    public Collection<License> getLicenses() {
        return this.licenses.values();
    }

    @Override
    @NotNull
    public LicenseStatus getLicenseStatus(@NotNull License license) {
        if (license.getExpireAt() < System.currentTimeMillis()) {
            return LicenseStatus.EXPIRED;
        }
        if (license.getStartAt() > System.currentTimeMillis()) {
            return LicenseStatus.NOT_STARTED;
        }
        return LicenseStatus.VALID;
    }

    @Override
    @NotNull
    public Collection<License> getValidLicenses() {
        return this.getLicenses().stream().filter(license -> this.getLicenseStatus((License)license) == LicenseStatus.VALID).toList();
    }

    @Override
    public boolean isFeatureEnabled(@NotNull String feature) {
        return this.getValidLicenses().stream().anyMatch(license -> license.getFeatures() != null && license.getFeatures().contains(feature));
    }

    @Override
    public Collection<String> getAllFeatures() {
        return this.getValidLicenses().stream().flatMap(license -> license.getFeatures() != null ? license.getFeatures().stream() : Stream.empty()).distinct().toList();
    }
}

