/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus.validator;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.validator.LicenseRevokeValidator;
import com.google.common.hash.Hashing;
import io.sentry.Sentry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BundledRevokeValidator
implements LicenseRevokeValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundledRevokeValidator.class);

    @Override
    public Collection<License> checkRevoked(@NotNull Collection<License> license) {
        return license.stream().filter(this::isRevoked).toList();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isRevoked(@NotNull License license) {
        try (InputStream is = Main.class.getResourceAsStream("/revoked-licenses.csv");){
            boolean bl;
            String headerLine;
            BufferedReader reader;
            block18: {
                if (is == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                headerLine = reader.readLine();
                if (headerLine != null) break block18;
                boolean bl3 = false;
                reader.close();
                return bl3;
            }
            try {
                String[] headers = headerLine.split(",");
                HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
                for (int i = 0; i < headers.length; ++i) {
                    headerMap.put(headers[i].trim(), i);
                }
                bl = reader.lines().anyMatch(line -> {
                    if (line.trim().isEmpty()) {
                        return false;
                    }
                    String[] columns = line.split(",", -1);
                    RevokedCSVItem item = new RevokedCSVItem();
                    item.setLicenseToHash(this.getColumnValue(columns, headerMap, "license_to_hash"));
                    item.setDescriptionHash(this.getColumnValue(columns, headerMap, "description_hash"));
                    item.setOrderIdHash(this.getColumnValue(columns, headerMap, "order_id_hash"));
                    item.setPaymentOrderIdHash(this.getColumnValue(columns, headerMap, "payment_order_id_hash"));
                    item.setEmailHash(this.getColumnValue(columns, headerMap, "email_hash"));
                    boolean result = false;
                    result = this.validateTrueShortCircuit(license.getLicenseTo(), item.getLicenseToHash(), result);
                    result = this.validateTrueShortCircuit(license.getDescription(), item.getDescriptionHash(), result);
                    result = this.validateTrueShortCircuit(license.getOrderId(), item.getOrderIdHash(), result);
                    result = this.validateTrueShortCircuit(license.getPaymentOrderId(), item.getPaymentOrderIdHash(), result);
                    result = this.validateTrueShortCircuit(license.getEmail(), item.getEmailHash(), result);
                    return result;
                });
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            reader.close();
            return bl;
        }
        catch (IOException e) {
            log.debug("Unable to validate license {} to check if it revoked locally: {}", (Object)license.getLicenseTo(), (Object)e.getMessage());
            Sentry.captureException((Throwable)e);
            return false;
        }
    }

    private String getColumnValue(String[] columns, Map<String, Integer> headerMap, String columnName) {
        Integer index = headerMap.get(columnName);
        if (index != null && index < columns.length) {
            String value = columns[index].trim();
            if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
                value = value.substring(1, value.length() - 1);
            }
            return value.isEmpty() ? null : value;
        }
        return null;
    }

    private boolean validateTrueShortCircuit(String unhashedValue, String compareTo, boolean anotherBoolean) {
        if (anotherBoolean) {
            return true;
        }
        if (unhashedValue == null) {
            return false;
        }
        String hashedValue = this.hash(unhashedValue);
        return compareTo.equalsIgnoreCase(hashedValue);
    }

    private String hash(String value) {
        if (value == null) {
            return null;
        }
        return Hashing.sha256().hashString((CharSequence)value, StandardCharsets.UTF_8).toString();
    }

    public static class RevokedCSVItem {
        @Nullable
        private String licenseToHash;
        @Nullable
        private String descriptionHash;
        @Nullable
        private String orderIdHash;
        @Nullable
        private String paymentOrderIdHash;
        @Nullable
        private String emailHash;

        @Generated
        public RevokedCSVItem(@Nullable String licenseToHash, @Nullable String descriptionHash, @Nullable String orderIdHash, @Nullable String paymentOrderIdHash, @Nullable String emailHash) {
            this.licenseToHash = licenseToHash;
            this.descriptionHash = descriptionHash;
            this.orderIdHash = orderIdHash;
            this.paymentOrderIdHash = paymentOrderIdHash;
            this.emailHash = emailHash;
        }

        @Generated
        public RevokedCSVItem() {
        }

        @Nullable
        @Generated
        public String getLicenseToHash() {
            return this.licenseToHash;
        }

        @Nullable
        @Generated
        public String getDescriptionHash() {
            return this.descriptionHash;
        }

        @Nullable
        @Generated
        public String getOrderIdHash() {
            return this.orderIdHash;
        }

        @Nullable
        @Generated
        public String getPaymentOrderIdHash() {
            return this.paymentOrderIdHash;
        }

        @Nullable
        @Generated
        public String getEmailHash() {
            return this.emailHash;
        }

        @Generated
        public void setLicenseToHash(@Nullable String licenseToHash) {
            this.licenseToHash = licenseToHash;
        }

        @Generated
        public void setDescriptionHash(@Nullable String descriptionHash) {
            this.descriptionHash = descriptionHash;
        }

        @Generated
        public void setOrderIdHash(@Nullable String orderIdHash) {
            this.orderIdHash = orderIdHash;
        }

        @Generated
        public void setPaymentOrderIdHash(@Nullable String paymentOrderIdHash) {
            this.paymentOrderIdHash = paymentOrderIdHash;
        }

        @Generated
        public void setEmailHash(@Nullable String emailHash) {
            this.emailHash = emailHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevokedCSVItem)) {
                return false;
            }
            RevokedCSVItem other = (RevokedCSVItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$licenseToHash = this.getLicenseToHash();
            String other$licenseToHash = other.getLicenseToHash();
            if (this$licenseToHash == null ? other$licenseToHash != null : !this$licenseToHash.equals(other$licenseToHash)) {
                return false;
            }
            String this$descriptionHash = this.getDescriptionHash();
            String other$descriptionHash = other.getDescriptionHash();
            if (this$descriptionHash == null ? other$descriptionHash != null : !this$descriptionHash.equals(other$descriptionHash)) {
                return false;
            }
            String this$orderIdHash = this.getOrderIdHash();
            String other$orderIdHash = other.getOrderIdHash();
            if (this$orderIdHash == null ? other$orderIdHash != null : !this$orderIdHash.equals(other$orderIdHash)) {
                return false;
            }
            String this$paymentOrderIdHash = this.getPaymentOrderIdHash();
            String other$paymentOrderIdHash = other.getPaymentOrderIdHash();
            if (this$paymentOrderIdHash == null ? other$paymentOrderIdHash != null : !this$paymentOrderIdHash.equals(other$paymentOrderIdHash)) {
                return false;
            }
            String this$emailHash = this.getEmailHash();
            String other$emailHash = other.getEmailHash();
            return !(this$emailHash == null ? other$emailHash != null : !this$emailHash.equals(other$emailHash));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RevokedCSVItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $licenseToHash = this.getLicenseToHash();
            result = result * 59 + ($licenseToHash == null ? 43 : $licenseToHash.hashCode());
            String $descriptionHash = this.getDescriptionHash();
            result = result * 59 + ($descriptionHash == null ? 43 : $descriptionHash.hashCode());
            String $orderIdHash = this.getOrderIdHash();
            result = result * 59 + ($orderIdHash == null ? 43 : $orderIdHash.hashCode());
            String $paymentOrderIdHash = this.getPaymentOrderIdHash();
            result = result * 59 + ($paymentOrderIdHash == null ? 43 : $paymentOrderIdHash.hashCode());
            String $emailHash = this.getEmailHash();
            result = result * 59 + ($emailHash == null ? 43 : $emailHash.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BundledRevokeValidator.RevokedCSVItem(licenseToHash=" + this.getLicenseToHash() + ", descriptionHash=" + this.getDescriptionHash() + ", orderIdHash=" + this.getOrderIdHash() + ", paymentOrderIdHash=" + this.getPaymentOrderIdHash() + ", emailHash=" + this.getEmailHash() + ")";
        }
    }
}

