/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class HTTPUtil
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPUtil.class);
    private static SSLContext ignoreSslContext;
    private Proxy.Type proxyType;
    private final List<Pattern> proxyBypasses = Collections.synchronizedList(new ArrayList());
    private Proxy proxyInstance;
    private final NetworkReachability networkReachability = new NetworkReachability();
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());
    public static final X509TrustManager IGNORE_SSL_TRUST_MANAGER_X509;
    final ProgressListener progressListener = new ProgressListener(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        void update0(long bytesRead, long contentLength, boolean done) {
            if (done) {
                log.info(TextManager.tlUI(Lang.DOWNLOAD_COMPLETED, bytesRead));
            } else if (contentLength != -1L) {
                log.info(TextManager.tlUI(Lang.DOWNLOAD_PROGRESS_DETERMINED, bytesRead, contentLength, String.format("%.2f", Float.valueOf(100.0f * (float)bytesRead / (float)contentLength))));
            } else {
                log.info(TextManager.tlUI(Lang.DOWNLOAD_PROGRESS, bytesRead));
            }
        }
    };

    public HTTPUtil() {
        Main.getReloadManager().register((Reloadable)this);
        this.reloadConfig();
        this.sched.scheduleAtFixedRate(this::checkReachability, 0L, 1L, TimeUnit.HOURS);
    }

    private void checkReachability() {
        OkHttpClient client = this.newBuilder().followSslRedirects(true).followRedirects(true).dispatcher(new Dispatcher(Executors.newVirtualThreadPerTaskExecutor())).callTimeout(10L, TimeUnit.SECONDS).build();
        Request cnNetworkCheck = new Request.Builder().url("https://www.qq.com/").head().build();
        try (Response response = client.newCall(cnNetworkCheck).execute();){
            this.networkReachability.setAccessToChinaNetwork(response.isSuccessful());
        }
        catch (IOException e) {
            this.networkReachability.setAccessToChinaNetwork(false);
        }
        Request globalNetworkCheck = new Request.Builder().url("https://www.google.com/generate_204").head().build();
        try (Response response = client.newCall(globalNetworkCheck).execute();){
            this.networkReachability.setAccessToGlobalNetwork(response.isSuccessful());
        }
        catch (IOException e) {
            this.networkReachability.setAccessToGlobalNetwork(false);
        }
    }

    public ReloadResult reloadModule() {
        this.reloadConfig();
        return new ReloadResult(ReloadStatus.SUCCESS, "", null);
    }

    private void reloadConfig() {
        this.proxyType = switch (Main.getMainConfig().getInt("proxy.setting", 0)) {
            case 1 -> Proxy.Type.HTTP;
            case 2 -> Proxy.Type.SOCKS;
            default -> Proxy.Type.DIRECT;
        };
        @Nullable String proxyHost = Main.getMainConfig().getString("proxy.host", "127.0.0.1");
        int proxyPort = Main.getMainConfig().getInt("proxy.port", 7890);
        this.proxyBypasses.clear();
        for (String proxy : Main.getMainConfig().getString("proxy.non-proxy-hosts", "").split("\\|")) {
            if (proxy.isEmpty()) continue;
            try {
                this.proxyBypasses.add(Pattern.compile(proxy.replace("*", ".*").replace("?", ".?")));
            }
            catch (Exception e) {
                log.error("Invalid proxy bypass pattern: {}", (Object)proxy, (Object)e);
            }
        }
        this.proxyInstance = this.proxyType == Proxy.Type.DIRECT ? Proxy.NO_PROXY : new Proxy(this.proxyType, InetSocketAddress.createUnresolved(proxyHost, proxyPort));
    }

    public OkHttpClient.Builder disableSSLVerify(OkHttpClient.Builder builder, boolean apply) {
        if (!apply) {
            return builder;
        }
        return builder.sslSocketFactory(HTTPUtil.getIgnoreInitedSslContext().getSocketFactory(), IGNORE_SSL_TRUST_MANAGER_X509).hostnameVerifier(HTTPUtil.getIgnoreSslHostnameVerifier());
    }

    public OkHttpClient.Builder addProgressTracker(OkHttpClient.Builder builder) {
        return this.addProgressTracker(builder, this.progressListener);
    }

    public OkHttpClient.Builder addProgressTracker(OkHttpClient.Builder builder, ProgressListener customProgressListener) {
        return builder.addNetworkInterceptor(chain -> {
            Response originalResponse = chain.proceed(chain.request());
            return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), customProgressListener)).build();
        });
    }

    public static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    public OkHttpClient.Builder newBuilderForDownloader() {
        OkHttpClient.Builder okHttpBuilder = this.newBuilder();
        if (ExternalSwitch.parseBoolean("pbh.downloader.bypassproxy", true)) {
            okHttpBuilder.proxy(Proxy.NO_PROXY);
        }
        return okHttpBuilder;
    }

    public OkHttpClient.Builder newBuilder() {
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().dispatcher(new Dispatcher(Executors.newVirtualThreadPerTaskExecutor())).connectTimeout(15L, TimeUnit.SECONDS).followRedirects(true).connectionPool(new ConnectionPool(5, 5L, TimeUnit.MINUTES)).followSslRedirects(true).fastFallback(true).retryOnConnectionFailure(true).cookieJar((CookieJar)new PBHCookieJar()).proxySelector(new ProxySelector(this){
            final /* synthetic */ HTTPUtil this$0;
            {
                HTTPUtil hTTPUtil = this$0;
                Objects.requireNonNull(hTTPUtil);
                this.this$0 = hTTPUtil;
            }

            @Override
            public List<Proxy> select(URI uri) {
                String host = uri.getHost();
                for (Pattern proxyBypass : this.this$0.proxyBypasses) {
                    if (!proxyBypass.matcher(host).matches()) continue;
                    log.debug("Direct route for host: {}, matched pattern: {}", (Object)host, (Object)proxyBypass.pattern());
                    return List.of(Proxy.NO_PROXY);
                }
                if (InetAddresses.isInetAddress((String)host) && IPAddressUtil.getIPAddress(host).isLocal()) {
                    log.debug("Direct route for host: {}, local IP", (Object)host);
                    return List.of(Proxy.NO_PROXY);
                }
                log.debug("Route via proxyInstance: {}", (Object)host);
                return List.of(this.this$0.proxyInstance);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        }).addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("User-Agent", Main.getUserAgent());
            return chain.proceed(requestBuilder.build());
        });
        if (ExternalSwitch.parseBoolean("pbh.http.logging", false)) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)log).debug(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            okHttpBuilder.addNetworkInterceptor((Interceptor)logging);
        }
        return okHttpBuilder;
    }

    public static SSLContext getIgnoreInitedSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{IGNORE_SSL_TRUST_MANAGER_X509}, new SecureRandom());
        return sslContext;
    }

    public static HostnameVerifier getIgnoreSslHostnameVerifier() {
        return (arg0, arg1) -> true;
    }

    @NotNull
    public NetworkReachability getNetworkReachability() {
        return this.networkReachability;
    }

    @Generated
    public static SSLContext getIgnoreSslContext() {
        return ignoreSslContext;
    }

    @Generated
    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    static {
        IGNORE_SSL_TRUST_MANAGER_X509 = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public static class NetworkReachability {
        private Boolean accessToChinaNetwork;
        private Boolean accessToGlobalNetwork;

        @Generated
        public NetworkReachability() {
        }

        @Generated
        public Boolean getAccessToChinaNetwork() {
            return this.accessToChinaNetwork;
        }

        @Generated
        public Boolean getAccessToGlobalNetwork() {
            return this.accessToGlobalNetwork;
        }

        @Generated
        public void setAccessToChinaNetwork(Boolean accessToChinaNetwork) {
            this.accessToChinaNetwork = accessToChinaNetwork;
        }

        @Generated
        public void setAccessToGlobalNetwork(Boolean accessToGlobalNetwork) {
            this.accessToGlobalNetwork = accessToGlobalNetwork;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkReachability)) {
                return false;
            }
            NetworkReachability other = (NetworkReachability)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$accessToChinaNetwork = this.getAccessToChinaNetwork();
            Boolean other$accessToChinaNetwork = other.getAccessToChinaNetwork();
            if (this$accessToChinaNetwork == null ? other$accessToChinaNetwork != null : !((Object)this$accessToChinaNetwork).equals(other$accessToChinaNetwork)) {
                return false;
            }
            Boolean this$accessToGlobalNetwork = this.getAccessToGlobalNetwork();
            Boolean other$accessToGlobalNetwork = other.getAccessToGlobalNetwork();
            return !(this$accessToGlobalNetwork == null ? other$accessToGlobalNetwork != null : !((Object)this$accessToGlobalNetwork).equals(other$accessToGlobalNetwork));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkReachability;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $accessToChinaNetwork = this.getAccessToChinaNetwork();
            result = result * 59 + ($accessToChinaNetwork == null ? 43 : ((Object)$accessToChinaNetwork).hashCode());
            Boolean $accessToGlobalNetwork = this.getAccessToGlobalNetwork();
            result = result * 59 + ($accessToGlobalNetwork == null ? 43 : ((Object)$accessToGlobalNetwork).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HTTPUtil.NetworkReachability(accessToChinaNetwork=" + this.getAccessToChinaNetwork() + ", accessToGlobalNetwork=" + this.getAccessToGlobalNetwork() + ")";
        }
    }

    public static abstract class ProgressListener {
        private long lastUpdateAt = 0L;
        private long lastBytesRead = 0L;

        void update(long bytesRead, long contentLength, boolean done) {
            if (System.currentTimeMillis() - this.lastUpdateAt < 5000L && bytesRead - this.lastBytesRead < 0x100000L && !done) {
                return;
            }
            this.lastUpdateAt = System.currentTimeMillis();
            this.lastBytesRead = bytesRead;
            this.update0(bytesRead, contentLength, done);
        }

        abstract void update0(long var1, long var3, boolean var5);
    }

    public static class PBHCookieJar
    implements CookieJar {
        private final Map<String, List<Cookie>> cookieStore = new ConcurrentHashMap<String, List<Cookie>>();

        public void saveFromResponse(HttpUrl httpUrl, @NotNull List<Cookie> list) {
            this.cookieStore.put(httpUrl.host(), list);
        }

        @NotNull
        public List<Cookie> loadForRequest(HttpUrl httpUrl) {
            ArrayList cookies = this.cookieStore.get(httpUrl.host());
            return cookies != null ? cookies : new ArrayList();
        }
    }

    private static class ProgressResponseBody
    extends ResponseBody {
        private final ResponseBody responseBody;
        private final ProgressListener progressListener;
        private BufferedSource bufferedSource;

        ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
            this.responseBody = responseBody;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        @NotNull
        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(this, source){
                long totalBytesRead;
                final /* synthetic */ ProgressResponseBody this$0;
                {
                    ProgressResponseBody progressResponseBody = this$0;
                    Objects.requireNonNull(progressResponseBody);
                    this.this$0 = progressResponseBody;
                    super(delegate);
                    this.totalBytesRead = 0L;
                }

                public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    this.this$0.progressListener.update(this.totalBytesRead, this.this$0.responseBody.contentLength(), bytesRead == -1L);
                    return bytesRead;
                }
            };
        }
    }
}

