/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.logger;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.SentryUtils;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.protocol.Message;
import java.util.Queue;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P6spyLogger
extends FormattedLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(P6spyLogger.class);
    public static final Queue<@NotNull String> sqlRingQueue = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)ExternalSwitch.parseInt("pbh.p6spy.ringqueue.size", 50)));
    public static final Queue<@NotNull String> writeSqlRingQueue = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)ExternalSwitch.parseInt("pbh.p6spy.writeringqueue.size", 30)));

    public void logException(Exception e) {
        log.error("P6Spy error logging", (Throwable)e);
    }

    public void logText(String text) {
        log.debug("[P6Spy] {}", (Object)text);
    }

    public void logSQL(int connectionId, String now, long elapsed, Category category, @Nullable String prepared, String sql, String url) {
        try {
            String loggingSQL = "[" + category.getName() + "] " + prepared + " | " + elapsed + " ms";
            sqlRingQueue.add(loggingSQL);
            if (prepared != null && !prepared.startsWith("SELECT") && (prepared.startsWith("INSERT") || prepared.startsWith("UPDATE") || prepared.startsWith("DELETE") || prepared.startsWith("ALTER") || prepared.startsWith("CREATE") || prepared.startsWith("DROP") || prepared.startsWith("TRUNCATE"))) {
                writeSqlRingQueue.add(loggingSQL);
            }
            if (category == Category.OUTAGE) {
                log.warn("[P6Spy] >>! OUTAGE/SLOW !<< {} | {} | took {} ms | {}\n{}", new Object[]{now, category.getName(), elapsed, prepared, MiscUtil.getAllThreadTrace()});
                SentryEvent event = new SentryEvent();
                Message msg = new Message();
                msg.setMessage("SQL Outage/Slow Query: " + prepared);
                event.setMessage(msg);
                event.setTag("category", category.getName());
                event.setExtra("elapsed_ms", (Object)elapsed);
                event.setExtra("timestamp", (Object)now);
                event.setExtra("prepared", (Object)prepared);
                event.setExtra("stacktrace", (Object)MiscUtil.getAllThreadTrace());
                if (ExternalSwitch.parseBoolean("pbh.p6spy.logsqlwithsentry", false)) {
                    event.setExtra("sql", (Object)sql);
                    event.setExtra("recent_write_queries", (Object)this.pollSqls(writeSqlRingQueue));
                    event.setExtra("recent_all_queries", (Object)this.pollSqls(sqlRingQueue));
                }
                event.setThreads(SentryUtils.getSentryThreads());
                Sentry.captureEvent((SentryEvent)event);
            }
            log.debug("[P6Spy] {} | {} | took {} ms | {}", new Object[]{now, category.getName(), elapsed, sql});
        }
        catch (Throwable th) {
            Sentry.captureException((Throwable)th);
        }
    }

    public String pollSqls(Queue<String> queue) {
        String sql;
        StringBuilder sb = new StringBuilder();
        while ((sql = queue.poll()) != null) {
            sb.append(sql).append("\n");
        }
        return sb.toString();
    }

    public boolean isCategoryEnabled(Category category) {
        return true;
    }
}

