/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.portmapper;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.portmapper.MappedPort;
import com.ghostchu.peerbanhelper.util.portmapper.PBHPortMapper;
import com.ghostchu.peerbanhelper.util.portmapper.Protocol;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
public final class PBHPortMapperImpl
implements PBHPortMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHPortMapperImpl.class);
    private GatewayDiscover gatewayDiscover = null;
    private boolean isShutdown = false;
    private final Object discoverLock = new Object();
    private final List<MappedPort> mappedPorts = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1);
    private final List<String> lastCheckedNics = new ArrayList<String>();
    private final Lock nicCheckChangeLock = new ReentrantLock();

    public PBHPortMapperImpl() {
        this.sched.scheduleWithFixedDelay(this::detectNICChange, 0L, 30L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                for (GatewayDevice gatewayDevice : this.getGatewayDevices()) {
                    for (MappedPort mappedPort : List.copyOf(this.mappedPorts)) {
                        executor.submit(() -> {
                            try {
                                gatewayDevice.deletePortMapping(mappedPort.getExternalPort(), mappedPort.getProtocol().name());
                            }
                            catch (IOException | SAXException e) {
                                log.debug("Unable to delete port mapping on shutdown", (Throwable)e);
                            }
                        });
                    }
                }
            }
        }));
    }

    private void detectNICChange() {
        if (this.nicCheckChangeLock.tryLock()) {
            try {
                List<String> currentNics = this.getAllNICs();
                if (!currentNics.equals(this.lastCheckedNics)) {
                    this.updateNICsList();
                    log.debug(TextManager.tlUI(Lang.PORT_MAPPER_NIC_CHANGES_DETECTED, new Object[0]));
                    Thread.ofVirtual().name("PortMapperScanner").start(this::scanMappers);
                }
            }
            finally {
                this.nicCheckChangeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanMappers() {
        Object object = this.discoverLock;
        synchronized (object) {
            if (this.isShutdown || !Main.getMainConfig().getBoolean("auto-stun.enabled", false)) {
                return;
            }
            log.info(TextManager.tlUI(Lang.PORTMAPPER_SCANNING, new Object[0]));
            try {
                this.updateNICsList();
                this.gatewayDiscover = new GatewayDiscover();
                this.gatewayDiscover.setTimeout(6000);
                this.gatewayDiscover.discover();
                log.info(TextManager.tlUI(Lang.PORTMAPPER_SCANNED, this.gatewayDiscover.getAllGateways().size()));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error(TextManager.tlUI(Lang.PORT_MAPPER_DISCOVER_IGD_FAILED, new Object[0]), (Throwable)e);
                log.error("Unable to discover UPnP gateways", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNICsList() {
        List<String> list = this.lastCheckedNics;
        synchronized (list) {
            this.lastCheckedNics.clear();
            this.lastCheckedNics.addAll(this.getAllNICs());
        }
    }

    private List<String> getAllNICs() {
        try {
            Enumeration<NetworkInterface> it = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> currentNics = new ArrayList<String>();
            it.asIterator().forEachRemaining(nic -> {
                try {
                    if (!nic.isUp() || nic.isLoopback() || nic.isVirtual() || nic.isPointToPoint()) {
                        return;
                    }
                    nic.getInetAddresses().asIterator().forEachRemaining(inetAddress -> currentNics.add(inetAddress.getHostAddress()));
                }
                catch (SocketException e) {
                    log.debug("Unable to process nics", (Throwable)e);
                }
            });
            Collections.sort(currentNics);
            return currentNics;
        }
        catch (SocketException e) {
            log.debug("Unable to update network interfaces collection", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GatewayDevice> getGatewayDevices() {
        Object object = this.discoverLock;
        synchronized (object) {
            if (this.gatewayDiscover == null) {
                return List.of();
            }
            if (this.gatewayDiscover.getValidGateway() == null) {
                this.scanMappers();
            }
            return List.copyOf(this.gatewayDiscover.getAllGateways().values());
        }
    }

    @Override
    public CompletableFuture<@NotNull Boolean> mapPort(int port, Protocol protocol, String description) {
        return CompletableFuture.supplyAsync(() -> {
            Collection<GatewayDevice> gateways = this.getGatewayDevices();
            if (gateways.isEmpty()) {
                log.debug("No UPnP gateways found, mapPort failed...");
                return false;
            }
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                AtomicBoolean anySuccess = new AtomicBoolean(false);
                for (GatewayDevice device : gateways) {
                    executor.submit(() -> {
                        try {
                            if (device.addPortMapping(port, port, device.getLocalAddress().getHostAddress(), protocol.name(), description)) {
                                log.info(TextManager.tlUI(Lang.PORT_MAPPER_PORT_MAPPED_NEW, device.getLocalAddress(), port, protocol.name(), device.getExternalIPAddress(), device.getFriendlyName(), device.getManufacturer(), device.getModelName(), device.getModelNumber()));
                                anySuccess.set(true);
                            }
                        }
                        catch (IOException | SAXException e) {
                            log.debug("Unable to add portMapping on port-mapping", (Throwable)e);
                        }
                    });
                    this.mappedPorts.add(new MappedPort(protocol, port));
                }
                Boolean i$ = anySuccess.get();
                return i$;
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    @Override
    public CompletableFuture<@NotNull Boolean> unmapPort(int port, Protocol protocol) {
        return CompletableFuture.supplyAsync(() -> {
            Collection<GatewayDevice> gateways = this.getGatewayDevices();
            if (gateways.isEmpty()) {
                log.debug("No UPnP gateways found, unmapPort failed...");
                return false;
            }
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                AtomicBoolean anySuccess = new AtomicBoolean(false);
                for (GatewayDevice device : gateways) {
                    executor.submit(() -> {
                        try {
                            if (device.deletePortMapping(port, protocol.name())) {
                                anySuccess.set(true);
                            }
                        }
                        catch (IOException | SAXException e) {
                            log.debug("Unable to delete portMapping on port-mapping", (Throwable)e);
                        }
                    });
                    this.mappedPorts.add(new MappedPort(protocol, port));
                }
                Boolean i$ = anySuccess.get();
                return i$;
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    @Override
    public void close() {
        this.isShutdown = true;
        this.sched.shutdown();
    }
}

