/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.pow;

import java.security.MessageDigest;
import java.security.SecureRandom;
import lombok.Generated;

public class PoWServer {
    private final byte[] challenge;
    private final int difficultyBits;
    private final String algorithm;

    public PoWServer(int difficultyBits, String algorithm) {
        this.difficultyBits = difficultyBits;
        this.challenge = new byte[32];
        this.algorithm = algorithm;
        new SecureRandom().nextBytes(this.challenge);
    }

    public boolean verify(byte[] nonce) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        digest.update(this.challenge);
        digest.update(nonce);
        byte[] hash = digest.digest();
        return this.hasLeadingZeroBits(hash, this.difficultyBits);
    }

    private boolean hasLeadingZeroBits(byte[] hash, int bits) {
        int fullBytes = bits / 8;
        int remainingBits = bits % 8;
        for (int i = 0; i < fullBytes; ++i) {
            if (hash[i] == 0) continue;
            return false;
        }
        if (remainingBits > 0) {
            int mask = 255 << 8 - remainingBits;
            return (hash[fullBytes] & mask) == 0;
        }
        return true;
    }

    @Generated
    public byte[] getChallenge() {
        return this.challenge;
    }

    @Generated
    public int getDifficultyBits() {
        return this.difficultyBits;
    }
}

