/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.javalin.http.Context;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Orderable
extends LinkedHashMap<String, Boolean> {
    private final BiMap<String, String> remapping = HashBiMap.create();

    public Orderable(Map<String, Boolean> def, Context ctx) {
        if (ctx != null && !ctx.queryParams("orderBy").isEmpty()) {
            this.appendOrders(ctx);
            for (Map.Entry<String, Boolean> entry : def.entrySet()) {
                this.putIfAbsent(entry.getKey(), entry.getValue());
            }
        } else {
            this.appendOrders(def);
        }
    }

    private Orderable appendOrders(String field, boolean asc) {
        this.put(field, asc);
        return this;
    }

    private Orderable appendOrders(Map<String, Boolean> fields) {
        this.putAll(fields);
        return this;
    }

    private Orderable appendOrders(Context ctx) {
        for (String orderBy : ctx.queryParams("orderBy")) {
            String[] spilt = orderBy.split("\\|");
            if (spilt.length == 0) continue;
            String dtoName = spilt[0];
            boolean asc = spilt.length < 2 || !"desc".equalsIgnoreCase(spilt[1]) && !"descend".equalsIgnoreCase(spilt[1]);
            this.put(dtoName, asc);
        }
        return this;
    }

    @NotNull
    public Orderable addRemapping(String oldName, String databaseFieldName) {
        this.remapping.put((Object)oldName, (Object)databaseFieldName);
        return this;
    }

    public <T> QueryWrapper<T> apply(QueryWrapper<T> queryBuilder) {
        if (queryBuilder == null) {
            return null;
        }
        for (Map.Entry entry : this.entrySet()) {
            queryBuilder.orderBy(true, ((Boolean)entry.getValue()).booleanValue(), (Object)((String)this.remapping.getOrDefault(entry.getKey(), (Object)((String)entry.getKey()))));
        }
        return queryBuilder;
    }

    public String generateOrderBy() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append((String)this.remapping.getOrDefault(entry.getKey(), (Object)((String)entry.getKey()))).append(" ").append((Boolean)entry.getValue() != false ? "ASC" : "DESC");
        }
        return sb.toString();
    }

    @Generated
    public BiMap<String, String> getRemapping() {
        return this.remapping;
    }
}

