/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.traversal.btstun;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.util.portmapper.PBHPortMapper;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProviderRegistry;
import com.ghostchu.peerbanhelper.util.traversal.btstun.BTStunInstance;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.sentry.Sentry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BTStunManager
implements AutoCloseable,
Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BTStunManager.class);
    private final Map<Downloader, BTStunInstance> perDownloaderStun = Collections.synchronizedMap(new HashMap());
    private final DownloaderManager downloaderManager;
    private final PBHPortMapper pBHPortMapper;
    private final NatAddressProviderRegistry natAddressProviderRegistry;
    private final BanList banList;
    private final Laboratory laboratory;
    private final IPDBManager iPDBManager;
    private boolean enabled = false;
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());

    public BTStunManager(BanList banList, DownloaderManager downloaderManager, PBHPortMapper pBHPortMapper, DownloaderServer downloaderServer, NatAddressProviderRegistry natAddressProviderRegistry, Laboratory laboratory, IPDBManager iPDBManager) {
        this.banList = banList;
        this.downloaderManager = downloaderManager;
        this.pBHPortMapper = pBHPortMapper;
        this.natAddressProviderRegistry = natAddressProviderRegistry;
        this.laboratory = laboratory;
        this.iPDBManager = iPDBManager;
        this.load();
        Runtime.getRuntime().addShutdownHook(Thread.ofPlatform().unstarted(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                Sentry.captureException((Throwable)e);
                throw new RuntimeException(e);
            }
        }));
        Main.getEventBus().register((Object)this);
    }

    private void load() {
        ConfigurationSection autoStun = Main.getMainConfig().getConfigurationSection("auto-stun");
        if (!autoStun.getBoolean("enabled", false)) {
            this.enabled = false;
            return;
        }
        this.sched.scheduleWithFixedDelay(this::scanAndLoad, 0L, 5L, TimeUnit.SECONDS);
        this.enabled = true;
    }

    private void scanAndLoad() {
        if (!this.enabled) {
            return;
        }
        ConfigurationSection autoStun = Main.getMainConfig().getConfigurationSection("auto-stun");
        for (String downloaderId : autoStun.getStringList("downloaders")) {
            Downloader downloader = this.downloaderManager.getDownloaderById(downloaderId);
            if (downloader == null) continue;
            if (downloader.getLastStatus() != DownloaderLastStatus.HEALTHY) {
                if (downloader.getFailedLoginAttempts() <= 10) continue;
                this.unregister(downloader);
                continue;
            }
            this.register(downloader);
        }
    }

    public boolean register(Downloader downloader) {
        if (this.perDownloaderStun.containsKey(downloader)) {
            return false;
        }
        if (!downloader.login().success()) {
            log.debug("Login failed for downloader: {}", (Object)downloader.getId());
            return false;
        }
        if (!downloader.getFeatureFlags().contains((Object)DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT)) {
            log.debug("Downloader does not support live update of BT protocol port: {}", (Object)downloader.getId());
            return false;
        }
        BTStunInstance instance = new BTStunInstance(this.banList, this.pBHPortMapper, downloader, this, this.laboratory, this.iPDBManager);
        this.perDownloaderStun.put(downloader, instance);
        this.natAddressProviderRegistry.add(instance);
        return true;
    }

    public void unregister(Downloader downloader) {
        BTStunInstance instance = this.perDownloaderStun.remove(downloader);
        this.natAddressProviderRegistry.remove(instance);
        if (instance != null) {
            try {
                instance.close();
            }
            catch (Exception e) {
                log.debug("Failed to close BTStunInstance for downloader: {}", (Object)downloader.getId(), (Object)e);
            }
        }
    }

    @Nullable
    public BTStunInstance getStunInstance(@NotNull Downloader downloader) {
        return this.perDownloaderStun.get(downloader);
    }

    public Map<Downloader, BTStunInstance> getDownloadStunInstances() {
        return this.perDownloaderStun;
    }

    public ReloadResult reloadModule() throws Exception {
        this.close();
        this.load();
        return super.reloadModule();
    }

    @Override
    public void close() {
        this.enabled = false;
        this.perDownloaderStun.values().forEach(instance -> {
            try {
                instance.close();
                this.natAddressProviderRegistry.remove(instance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.perDownloaderStun.clear();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }
}

