/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.web;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.logger.JListAppender;
import com.ghostchu.peerbanhelper.util.logger.LogEntry;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;

public class EarlyStartupHandler
implements Handler {
    public void handle(@NotNull Context ctx) throws Exception {
        try (InputStream res = Main.class.getResourceAsStream("/early-starting.html");){
            if (res == null) {
                ctx.html("PeerBanHelper Starting (Fallback Page)...");
                return;
            }
            String html = new String(res.readAllBytes(), StandardCharsets.UTF_8).replace("${EARLY_STARTING_TITLE}", TextManager.tlUI(Lang.EARLY_STARTING_TITLE, new Object[0])).replace("${EARLY_STARTING_PAGE_TITLE}", TextManager.tlUI(Lang.EARLY_STARTING_PAGE_TITLE, new Object[0])).replace("${EARLY_STARTING_PAGE_DESCRIPTION}", TextManager.tlUI(Lang.EARLY_STARTING_PAGE_DESCRIPTION, new Object[0])).replace("${EARLY_STARTING_PAGE_CONTENT}", this.generateLogsHTML());
            ctx.header("Cache-Control", "no-cache, no-store, must-revalidate").header("Pragma", "no-cache").header("Expires", "0").html(html);
        }
    }

    private String generateLogsHTML() {
        ArrayList logs = new ArrayList(JListAppender.ringDeque.stream().limit(100L).toList());
        Collections.reverse(logs);
        StringBuilder html = new StringBuilder("<div class='terminal'>");
        for (LogEntry entry : logs) {
            String timestamp = MsgUtil.getTimeFormatter().format(new Date(entry.time()));
            String line = "[%s] [%s/%s]: %s".formatted(timestamp, entry.thread(), entry.level(), entry.content());
            String cssClass = "log-line " + this.getLogClass(entry.level());
            html.append("<div class='").append(cssClass).append("'>").append(this.escapeHtml(line)).append("</div>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getLogClass(Level level) {
        return switch (level) {
            case Level.ERROR -> "log-error";
            case Level.WARN -> "log-warn";
            case Level.DEBUG -> "log-debug";
            default -> "";
        };
    }

    private String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }
}

