/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AsyncSemaphore;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.base64;

abstract class DohResolverCommon
implements Resolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DohResolverCommon.class);
    protected final AsyncSemaphore maxConcurrentRequests;
    protected final AtomicLong lastRequest = new AtomicLong(0L);
    protected static final String APPLICATION_DNS_MESSAGE = "application/dns-message";
    protected boolean usePost = false;
    protected Duration timeout = Duration.ofSeconds(5L);
    protected String uriTemplate;
    protected OPTRecord queryOPT = new OPTRecord(0, 0, 0);
    protected TSIG tsig;
    protected Executor defaultExecutor = ForkJoinPool.commonPool();

    long getNanoTime() {
        return System.nanoTime();
    }

    protected DohResolverCommon(String uriTemplate, int maxConcurrentRequests) {
        this.uriTemplate = uriTemplate;
        if (maxConcurrentRequests <= 0) {
            throw new IllegalArgumentException("maxConcurrentRequests must be > 0");
        }
        try {
            int javaMaxConn = Integer.parseInt(System.getProperty("http.maxConnections", "5"));
            if (maxConcurrentRequests > javaMaxConn) {
                maxConcurrentRequests = javaMaxConn;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.maxConcurrentRequests = new AsyncSemaphore(maxConcurrentRequests, "concurrent request limit");
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public void setTCP(boolean flag) {
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        switch (version) {
            case -1: {
                this.queryOPT = null;
                break;
            }
            case 0: {
                this.queryOPT = new OPTRecord(0, 0, version, flags, options);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid EDNS version - must be 0 or -1 to disable");
            }
        }
    }

    @Override
    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    protected String getUrl(byte[] queryBytes) {
        String url = this.uriTemplate;
        if (!this.usePost) {
            url = url + "?dns=" + base64.toString(queryBytes, true);
        }
        return url;
    }

    protected Message prepareQuery(Message query) {
        Message preparedQuery = query.clone();
        preparedQuery.getHeader().setID(0);
        if (this.queryOPT != null && preparedQuery.getOPT() == null) {
            preparedQuery.addRecord(this.queryOPT, 3);
        }
        if (this.tsig != null) {
            this.tsig.apply(preparedQuery, null);
        }
        return preparedQuery;
    }

    protected void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        int error = tsig.verify(response, b, query.getGeneratedTSIG());
        log.debug("TSIG verify for query {}, {}/{}: {}", new Object[]{query.getHeader().getID(), query.getQuestion().getName(), Type.string(query.getQuestion().getType()), Rcode.TSIGstring(error)});
    }

    public boolean isUsePost() {
        return this.usePost;
    }

    public void setUsePost(boolean usePost) {
        this.usePost = usePost;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    @Deprecated
    public Executor getExecutor() {
        return this.defaultExecutor;
    }

    @Deprecated
    public void setExecutor(Executor executor) {
        this.defaultExecutor = executor == null ? ForkJoinPool.commonPool() : executor;
    }

    public String toString() {
        return "DohResolver {" + (this.usePost ? "POST " : "GET ") + this.uriTemplate + "}";
    }

    protected abstract <T> CompletableFuture<T> failedFuture(Throwable var1);

    protected final <T> CompletableFuture<T> timeoutFailedFuture(Message query, Throwable inner) {
        return this.timeoutFailedFuture(query, null, inner);
    }

    protected final <T> CompletableFuture<T> timeoutFailedFuture(Message query, String message, Throwable inner) {
        return this.failedFuture(new TimeoutException("Query " + query.getHeader().getID() + " for " + query.getQuestion().getName() + "/" + Type.string(query.getQuestion().getType()) + " timed out" + (message != null ? ": " + message : "") + (inner != null && inner.getMessage() != null ? ", " + inner.getMessage() : "")));
    }
}

