/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.PacketLogger;
import org.xbill.DNS.utils.hexdump;

public abstract class NioClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NioClient.class);
    static final String SELECTOR_TIMEOUT_PROPERTY = "dnsjava.nio.selector_timeout";
    static final String REGISTER_SHUTDOWN_HOOK_PROPERTY = "dnsjava.nio.register_shutdown_hook";
    private static final Object NIO_CLIENT_LOCK = new Object();
    private static PacketLogger packetLogger = null;
    private static final Runnable[] TIMEOUT_TASKS = new Runnable[2];
    private static Consumer<Selector> TCP_REGISTRATIONS_TASK;
    private static Consumer<Selector> UDP_REGISTRATIONS_TASK;
    private static final Runnable[] CLOSE_TASKS;
    private static Thread selectorThread;
    private static Thread closeThread;
    private static volatile Selector selector;
    private static volatile boolean run;
    private static volatile boolean closeDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Selector selector() throws IOException {
        if (selector == null) {
            Object object = NIO_CLIENT_LOCK;
            synchronized (object) {
                if (selector == null) {
                    selector = Selector.open();
                    log.debug("Starting dnsjava NIO selector thread");
                    run = true;
                    selectorThread = new Thread(NioClient::runSelector);
                    selectorThread.setDaemon(true);
                    selectorThread.setName("dnsjava NIO selector");
                    selectorThread.start();
                    closeThread = new Thread(() -> NioClient.close(true));
                    closeThread.setName("dnsjava NIO shutdown hook");
                    if (Boolean.parseBoolean(System.getProperty(REGISTER_SHUTDOWN_HOOK_PROPERTY, "true"))) {
                        Runtime.getRuntime().addShutdownHook(closeThread);
                    }
                }
            }
        }
        return selector;
    }

    public static void close() {
        NioClient.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(boolean fromHook) {
        Object object;
        run = false;
        Selector localSelector = selector;
        if (localSelector != null) {
            selector.wakeup();
        }
        if (!fromHook) {
            object = NIO_CLIENT_LOCK;
            synchronized (object) {
                if (closeThread != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(closeThread);
                    }
                    catch (Exception ex) {
                        log.warn("Failed to remove shutdown hook, ignoring and continuing close", (Throwable)ex);
                    }
                }
            }
        }
        if (localSelector == null) {
            return;
        }
        object = NIO_CLIENT_LOCK;
        synchronized (object) {
            try {
                while (!closeDone) {
                    NIO_CLIENT_LOCK.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                closeDone = false;
            }
        }
    }

    static void runSelector() {
        int timeout = Integer.getInteger(SELECTOR_TIMEOUT_PROPERTY, 1000);
        if (timeout <= 0 || timeout > 1000) {
            throw new IllegalArgumentException("Invalid selector_timeout, must be between 1 and 1000");
        }
        while (run) {
            try {
                if (selector.select(timeout) == 0) {
                    NioClient.runTasks(TIMEOUT_TASKS);
                }
                if (!run) continue;
                NioClient.runRegistrationTasks();
                NioClient.processReadyKeys();
            }
            catch (IOException e) {
                log.error("A selection operation failed", (Throwable)e);
            }
            catch (ClosedSelectorException closedSelectorException) {}
        }
        NioClient.runClose();
        log.debug("dnsjava NIO selector thread stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runClose() {
        try {
            NioClient.runTasks(CLOSE_TASKS);
        }
        catch (Exception e) {
            log.warn("Failed to execute shutdown task, ignoring and continuing close", (Throwable)e);
        }
        Selector localSelector = selector;
        Thread localSelectorThread = selectorThread;
        Object object = NIO_CLIENT_LOCK;
        synchronized (object) {
            selector = null;
            selectorThread = null;
            closeThread = null;
            closeDone = true;
            NIO_CLIENT_LOCK.notifyAll();
        }
        if (localSelector != null) {
            try {
                localSelector.close();
            }
            catch (IOException e) {
                log.warn("Failed to properly close selector, ignoring and continuing close", (Throwable)e);
            }
        }
        if (localSelectorThread != null) {
            try {
                localSelectorThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static void setTimeoutTask(Runnable r, boolean isTcpClient) {
        NioClient.addTask(TIMEOUT_TASKS, r, isTcpClient);
    }

    static void setRegistrationsTask(Consumer<Selector> r, boolean isTcpClient) {
        if (isTcpClient) {
            TCP_REGISTRATIONS_TASK = r;
        } else {
            UDP_REGISTRATIONS_TASK = r;
        }
    }

    static void setCloseTask(Runnable r, boolean isTcpClient) {
        NioClient.addTask(CLOSE_TASKS, r, isTcpClient);
    }

    private static void addTask(Runnable[] tasks, Runnable r, boolean isTcpClient) {
        if (isTcpClient) {
            tasks[0] = r;
        } else {
            tasks[1] = r;
        }
    }

    private static void runTasks(Runnable[] runnables) {
        Runnable r1;
        Runnable r0 = runnables[0];
        if (r0 != null) {
            r0.run();
        }
        if ((r1 = runnables[1]) != null) {
            r1.run();
        }
    }

    private static void runRegistrationTasks() {
        Consumer<Selector> udpTask;
        Consumer<Selector> tcpTask = TCP_REGISTRATIONS_TASK;
        if (tcpTask != null) {
            tcpTask.accept(selector);
        }
        if ((udpTask = UDP_REGISTRATIONS_TASK) != null) {
            udpTask.accept(selector);
        }
    }

    private static void processReadyKeys() {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            KeyProcessor t = (KeyProcessor)key.attachment();
            t.processReadyKey(key);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, ByteBuffer data) {
        if (log.isTraceEnabled() || packetLogger != null) {
            byte[] dst = new byte[data.remaining()];
            int pos = data.position();
            data.get(dst, 0, data.remaining());
            data.position(pos);
            NioClient.verboseLog(prefix, local, remote, dst);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, byte[] data) {
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump(prefix, data));
        }
        if (packetLogger != null) {
            packetLogger.log(prefix, local, remote, data);
        }
    }

    static void setPacketLogger(PacketLogger logger) {
        packetLogger = logger;
    }

    static {
        CLOSE_TASKS = new Runnable[2];
    }

    static interface KeyProcessor {
        public void processReadyKey(SelectionKey var1);
    }
}

