# History

-----

Important changes are emphasized.

## Unreleased

## 21.0.0

- **Breaking:** Drop support for Python 3.8
- Add support for Python 3.13
- Remove all runtime dependencies (`cffi` & `asn1crypto`)
- Add `COINCURVE_VENDOR_CFFI` environment variable to control vendoring of the `_cffi_backend` module
- Minor performance improvement by removing use of formatted string constants
- Upgrade [libsecp256k1][] to version 0.6.0

## 20.0.0

- **Breaking:** CMake is now a build dependency; this is only a breaking change for redistributors as building with standard Python packaging tools will automatically use the CMake that is available on PyPI
- **Breaking:** Stop building wheels for Windows 32-bit
- Build wheels for Windows ARM64
- Upgrade [libsecp256k1][] to version 0.5.0

## 19.0.1

- Fix regression in Windows wheels

## 19.0.0

- **Breaking:** Drop support for Python 3.7
- Add support for Python 3.12
- Upgrade [libsecp256k1][] to version 0.4.1

## 18.0.0

- Support Schnorr signatures
- Add support for Python 3.11
- Upgrade [libsecp256k1][] to the latest available version

## 17.0.0

- **Breaking:** Drop support for Python 3.6
- Fix wheels for Apple M1
- Upgrade [libsecp256k1][] to the latest available version

## 16.0.0

- Wheels for Apple Silicon and musl linux (Alpine)
- No wheels for PyPy until the build system is fixed

## 15.0.1

- Fix the `combine` method of `PublicKey`

## 15.0.0

- **Breaking:** Drop support for Python 2
- **Breaking:** Binary wheels for CPython require version 19.3 or later of ``pip`` to install
- Build AArch64 binary wheels for Linux
- Build binary wheels for PyPy3.6 7.3.3 & PyPy3.7 7.3.3 on Linux
- Upgrade [libsecp256k1][] to the latest available version
- Upgrade libgmp to the latest available version
- Introduce `COINCURVE_UPSTREAM_REF` environment variable to select an alternative [libsecp256k1][] version when building from source
- Support PEP 561 type hints
- Added support for supplying a custom nonce to `PrivateKey.sign_recoverable`

## 14.0.0

**IMPORTANT: This will be the final release that supports Python 2.**

- **New:** Binary wheels for Python 3.9
- **Breaking:** Drop support for Python 3.5
- Fetch [libsecp256k1][] source if the system installation lacks ECDH support
- Fix innocuous `setuptools` warning when building from source
- Switch CI/CD to GitHub Actions

## 13.0.0

- **New:** Binary wheels for Python 3.8
- Support building on OpenBSD
- Improve handling of PEM private key deserialization
- Improve ECDH documentation
- Improvements from [libsecp256k1][] master

## 12.0.0

- **New:** Binary wheels on Linux for PyPy3.6 v7.1.1-beta
- **New:** Binary wheels on macOS for Python 3.8.0-alpha.3
- **New:** Binary wheels on Linux are now also built with the new [manylinux2010](https://www.python.org/dev/peps/pep-0571) spec for 64-bit platforms
- Improvements from [libsecp256k1][] master

## 11.0.0

- Fix some linking scenarios by placing bundled [libsecp256k1][] dir first in path
- Allow override of system [libsecp256k1][] with environment variable
- Add benchmarks
- Use Codecov to track coverage
- Use black for code formatting

## 10.0.0

- Support tox for testing
- Compatibility with latest [libsecp256k1][] ECDH API
- Make libgmp optional when building from source

## 9.0.0

- Fixed wheels for macOS
- **Breaking:** Drop support for 32-bit macOS

## 8.0.2

- No longer package tests

## 8.0.0

- **New:** Binary wheels for Python 3.7
- **Changed:** Binary wheels on macOS for Python 3.5 now use Homebrew
  Python for compilation due to new security requirements
- Make build system support new GitHub & PyPI security requirements
- Improvements from [libsecp256k1][] master

## 7.1.0

- Pin version of [libsecp256k1][]
- Improve docs

## 7.0.0

- Improvements from [libsecp256k1][] master
- Fix build script

## 6.0.0

- Resolved #6. You can choose to use this or remain on `5.2.0`. This will only be a temporary change, see 3e93480b3e38c6b9beb0bc2de83bc3630fc74c46.

## 5.2.0

- Added support for supplying a custom nonce to `PrivateKey.sign`

## 5.1.0

- Added `PublicKey.combine_keys` class method
- Improvements to documentation

## 5.0.1

- Fixed an issue where secret validation would occasionally erroneously error
  on user-provided secrets (secrets not generated by Coincurve itself) if there
  were not exactly 256 bits of entropy. See #5.

## 5.0.0

- **Breaking:** Coincurve is now dual-licensed under the terms of `MIT` and `Apache-2.0`
- Performance improvements from [libsecp256k1][] master
- Improvements to documentation.

## 4.5.1

- First public stable release
