# SPDX-License-Identifier: MIT
# Copyright (C) 2018-present iced project and contributors

# ⚠️This file was generated by GENERATOR!🦹‍♂️

# pylint: disable=invalid-name
# pylint: disable=line-too-long
# pylint: disable=too-many-lines

"""
MVEX tuple type lut kind used together with the ``MVEX.SSS`` bits to get the tuple type
"""

import typing
if typing.TYPE_CHECKING:
	from ._iced_x86_py import MvexTupleTypeLutKind
else:
	MvexTupleTypeLutKind = int

INT32: MvexTupleTypeLutKind = 0 # type: ignore
"""
``i32`` elements, eg. ``Si32``/``Di32``/``Ui32``
"""
INT32_HALF: MvexTupleTypeLutKind = 1 # type: ignore
"""
``i32`` elements, eg. ``Si32``/``Di32``/``Ui32`` with half memory size (32 bytes instead of 64 bytes, eg. ``VCVTUDQ2PD``/``VCVTDQ2PD``)
"""
INT32_4TO16: MvexTupleTypeLutKind = 2 # type: ignore
"""
``i32`` elements, eg. ``Si32``/``Di32``/``Ui32`` with built-in ``{4to16}`` broadcast
"""
INT32_1TO16_OR_ELEM: MvexTupleTypeLutKind = 3 # type: ignore
"""
``i32`` elements, eg. ``Si32``/``Di32``/``Ui32`` with built-in ``{1to16}`` broadcast or element level
"""
INT64: MvexTupleTypeLutKind = 4 # type: ignore
"""
``i64`` elements, eg. ``Si64``/``Di64``/``Ui64``
"""
INT64_4TO8: MvexTupleTypeLutKind = 5 # type: ignore
"""
``i64`` elements, eg. ``Si64``/``Di64``/``Ui64`` with built-in ``{4to8}`` broadcast
"""
INT64_1TO8_OR_ELEM: MvexTupleTypeLutKind = 6 # type: ignore
"""
``i64`` elements, eg. ``Si64``/``Di64``/``Ui64`` with built-in ``{1to8}`` broadcast or element level
"""
FLOAT32: MvexTupleTypeLutKind = 7 # type: ignore
"""
``f32`` elements, eg. ``Sf32``/``Df32``/``Uf32``
"""
FLOAT32_HALF: MvexTupleTypeLutKind = 8 # type: ignore
"""
``f32`` elements, eg. ``Sf32``/``Df32``/``Uf32`` with half memory size (32 bytes instead of 64 bytes, eg. ``VCVTPS2PD``
"""
FLOAT32_4TO16: MvexTupleTypeLutKind = 9 # type: ignore
"""
``f32`` elements, eg. ``Sf32``/``Df32``/``Uf32`` with built-in ``{4to16}`` broadcast
"""
FLOAT32_1TO16_OR_ELEM: MvexTupleTypeLutKind = 10 # type: ignore
"""
``f32`` elements, eg. ``Sf32``/``Df32``/``Uf32`` with built-in ``{1to16}`` broadcast or element level
"""
FLOAT64: MvexTupleTypeLutKind = 11 # type: ignore
"""
``f64`` elements, eg. ``Sf64``/``Df64``/``Uf64``
"""
FLOAT64_4TO8: MvexTupleTypeLutKind = 12 # type: ignore
"""
``f64`` elements, eg. ``Sf64``/``Df64``/``Uf64`` with built-in ``{4to8}`` broadcast
"""
FLOAT64_1TO8_OR_ELEM: MvexTupleTypeLutKind = 13 # type: ignore
"""
``f64`` elements, eg. ``Sf64``/``Df64``/``Uf64`` with built-in ``{1to8}`` broadcast or element level
"""
