# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .video_stream_feature import VideoStreamFeature
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoStreamObjectTrackingFeature(VideoStreamFeature):
    """
    Video stream object tracking feature
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoStreamObjectTrackingFeature object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_vision.models.VideoStreamObjectTrackingFeature.feature_type` attribute
        of this class is ``OBJECT_TRACKING`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature_type:
            The value to assign to the feature_type property of this VideoStreamObjectTrackingFeature.
            Allowed values for this property are: "OBJECT_TRACKING", "FACE_DETECTION", "OBJECT_DETECTION"
        :type feature_type: str

        :param tracking_types:
            The value to assign to the tracking_types property of this VideoStreamObjectTrackingFeature.
        :type tracking_types: list[oci.ai_vision.models.TrackingType]

        """
        self.swagger_types = {
            'feature_type': 'str',
            'tracking_types': 'list[TrackingType]'
        }
        self.attribute_map = {
            'feature_type': 'featureType',
            'tracking_types': 'trackingTypes'
        }
        self._feature_type = None
        self._tracking_types = None
        self._feature_type = 'OBJECT_TRACKING'

    @property
    def tracking_types(self):
        """
        **[Required]** Gets the tracking_types of this VideoStreamObjectTrackingFeature.
        List of details of what to track.


        :return: The tracking_types of this VideoStreamObjectTrackingFeature.
        :rtype: list[oci.ai_vision.models.TrackingType]
        """
        return self._tracking_types

    @tracking_types.setter
    def tracking_types(self, tracking_types):
        """
        Sets the tracking_types of this VideoStreamObjectTrackingFeature.
        List of details of what to track.


        :param tracking_types: The tracking_types of this VideoStreamObjectTrackingFeature.
        :type: list[oci.ai_vision.models.TrackingType]
        """
        self._tracking_types = tracking_types

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
