# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateBatchContextDetails(object):
    """
    The data to update a batch context.
    If the value of a collection is explicitly provided as null, it will be converted to an empty value, i.e. \"[]\" or \"{}\" in json notation. This applies to nested collections as well.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateBatchContextDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateBatchContextDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateBatchContextDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateBatchContextDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateBatchContextDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param job_priority_configurations:
            The value to assign to the job_priority_configurations property of this UpdateBatchContextDetails.
        :type job_priority_configurations: list[oci.batch.models.JobPriorityConfiguration]

        :param entitlements:
            The value to assign to the entitlements property of this UpdateBatchContextDetails.
        :type entitlements: dict(str, int)

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'job_priority_configurations': 'list[JobPriorityConfiguration]',
            'entitlements': 'dict(str, int)'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'job_priority_configurations': 'jobPriorityConfigurations',
            'entitlements': 'entitlements'
        }
        self._display_name = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._job_priority_configurations = None
        self._entitlements = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateBatchContextDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Can't be set to null.


        :return: The display_name of this UpdateBatchContextDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateBatchContextDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Can't be set to null.


        :param display_name: The display_name of this UpdateBatchContextDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateBatchContextDetails.
        Summarized information about the batch context.


        :return: The description of this UpdateBatchContextDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateBatchContextDetails.
        Summarized information about the batch context.


        :param description: The description of this UpdateBatchContextDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateBatchContextDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateBatchContextDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateBatchContextDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateBatchContextDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateBatchContextDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateBatchContextDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateBatchContextDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateBatchContextDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def job_priority_configurations(self):
        """
        Gets the job_priority_configurations of this UpdateBatchContextDetails.
        List of job priority configurations related to the batch context.


        :return: The job_priority_configurations of this UpdateBatchContextDetails.
        :rtype: list[oci.batch.models.JobPriorityConfiguration]
        """
        return self._job_priority_configurations

    @job_priority_configurations.setter
    def job_priority_configurations(self, job_priority_configurations):
        """
        Sets the job_priority_configurations of this UpdateBatchContextDetails.
        List of job priority configurations related to the batch context.


        :param job_priority_configurations: The job_priority_configurations of this UpdateBatchContextDetails.
        :type: list[oci.batch.models.JobPriorityConfiguration]
        """
        self._job_priority_configurations = job_priority_configurations

    @property
    def entitlements(self):
        """
        Gets the entitlements of this UpdateBatchContextDetails.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :return: The entitlements of this UpdateBatchContextDetails.
        :rtype: dict(str, int)
        """
        return self._entitlements

    @entitlements.setter
    def entitlements(self, entitlements):
        """
        Sets the entitlements of this UpdateBatchContextDetails.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :param entitlements: The entitlements of this UpdateBatchContextDetails.
        :type: dict(str, int)
        """
        self._entitlements = entitlements

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
