# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FirmwareBundle(object):
    """
    A collection of pinned component firmware versions organized by platform.
    """

    #: A constant which can be used with the lifecycle_state property of a FirmwareBundle.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FirmwareBundle.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FirmwareBundle.
    #: This constant has a value of "DELETE_SCHEDULED"
    LIFECYCLE_STATE_DELETE_SCHEDULED = "DELETE_SCHEDULED"

    def __init__(self, **kwargs):
        """
        Initializes a new FirmwareBundle object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FirmwareBundle.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this FirmwareBundle.
        :type display_name: str

        :param description:
            The value to assign to the description property of this FirmwareBundle.
        :type description: str

        :param platforms:
            The value to assign to the platforms property of this FirmwareBundle.
        :type platforms: list[oci.core.models.PlatformVersions]

        :param allowable_transitions:
            The value to assign to the allowable_transitions property of this FirmwareBundle.
        :type allowable_transitions: oci.core.models.FirmwareBundleTransitions

        :param compartment_id:
            The value to assign to the compartment_id property of this FirmwareBundle.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this FirmwareBundle.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FirmwareBundle.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FirmwareBundle.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETE_SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'platforms': 'list[PlatformVersions]',
            'allowable_transitions': 'FirmwareBundleTransitions',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'platforms': 'platforms',
            'allowable_transitions': 'allowableTransitions',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._platforms = None
        self._allowable_transitions = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FirmwareBundle.
        The `OCID`__ of this firmware bundle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this FirmwareBundle.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FirmwareBundle.
        The `OCID`__ of this firmware bundle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this FirmwareBundle.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FirmwareBundle.
        The user-friendly name of this firmware bundle.


        :return: The display_name of this FirmwareBundle.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FirmwareBundle.
        The user-friendly name of this firmware bundle.


        :param display_name: The display_name of this FirmwareBundle.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this FirmwareBundle.
        A brief description or metadata about this firmware bundle.


        :return: The description of this FirmwareBundle.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FirmwareBundle.
        A brief description or metadata about this firmware bundle.


        :param description: The description of this FirmwareBundle.
        :type: str
        """
        self._description = description

    @property
    def platforms(self):
        """
        **[Required]** Gets the platforms of this FirmwareBundle.
        A map of platforms to pinned firmware versions.


        :return: The platforms of this FirmwareBundle.
        :rtype: list[oci.core.models.PlatformVersions]
        """
        return self._platforms

    @platforms.setter
    def platforms(self, platforms):
        """
        Sets the platforms of this FirmwareBundle.
        A map of platforms to pinned firmware versions.


        :param platforms: The platforms of this FirmwareBundle.
        :type: list[oci.core.models.PlatformVersions]
        """
        self._platforms = platforms

    @property
    def allowable_transitions(self):
        """
        Gets the allowable_transitions of this FirmwareBundle.

        :return: The allowable_transitions of this FirmwareBundle.
        :rtype: oci.core.models.FirmwareBundleTransitions
        """
        return self._allowable_transitions

    @allowable_transitions.setter
    def allowable_transitions(self, allowable_transitions):
        """
        Sets the allowable_transitions of this FirmwareBundle.

        :param allowable_transitions: The allowable_transitions of this FirmwareBundle.
        :type: oci.core.models.FirmwareBundleTransitions
        """
        self._allowable_transitions = allowable_transitions

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FirmwareBundle.
        The `OCID`__ of the compartment of this firmware bundle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this FirmwareBundle.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FirmwareBundle.
        The `OCID`__ of the compartment of this firmware bundle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this FirmwareBundle.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FirmwareBundle.
        The date and time the firmware bundle was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this FirmwareBundle.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FirmwareBundle.
        The date and time the firmware bundle was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this FirmwareBundle.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this FirmwareBundle.
        The date and time the firmware bundle was updated, in the format defined by `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this FirmwareBundle.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FirmwareBundle.
        The date and time the firmware bundle was updated, in the format defined by `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this FirmwareBundle.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FirmwareBundle.
        The current state of the firmware bundle.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETE_SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FirmwareBundle.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FirmwareBundle.
        The current state of the firmware bundle.


        :param lifecycle_state: The lifecycle_state of this FirmwareBundle.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "DELETE_SCHEDULED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
