# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedResourceSummary(object):
    """
    Summary details of the associated resource of an attribute set.
    """

    #: A constant which can be used with the associated_resource_type property of a AssociatedResourceSummary.
    #: This constant has a value of "AUDIT_POLICY"
    ASSOCIATED_RESOURCE_TYPE_AUDIT_POLICY = "AUDIT_POLICY"

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param associated_resource_type:
            The value to assign to the associated_resource_type property of this AssociatedResourceSummary.
            Allowed values for this property are: "AUDIT_POLICY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type associated_resource_type: str

        :param associated_resource_id:
            The value to assign to the associated_resource_id property of this AssociatedResourceSummary.
        :type associated_resource_id: str

        :param associated_resource_name:
            The value to assign to the associated_resource_name property of this AssociatedResourceSummary.
        :type associated_resource_name: str

        :param time_created:
            The value to assign to the time_created property of this AssociatedResourceSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AssociatedResourceSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'associated_resource_type': 'str',
            'associated_resource_id': 'str',
            'associated_resource_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'associated_resource_type': 'associatedResourceType',
            'associated_resource_id': 'associatedResourceId',
            'associated_resource_name': 'associatedResourceName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._associated_resource_type = None
        self._associated_resource_id = None
        self._associated_resource_name = None
        self._time_created = None
        self._time_updated = None

    @property
    def associated_resource_type(self):
        """
        Gets the associated_resource_type of this AssociatedResourceSummary.
        The resource type that is associated with the attribute set.

        Allowed values for this property are: "AUDIT_POLICY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The associated_resource_type of this AssociatedResourceSummary.
        :rtype: str
        """
        return self._associated_resource_type

    @associated_resource_type.setter
    def associated_resource_type(self, associated_resource_type):
        """
        Sets the associated_resource_type of this AssociatedResourceSummary.
        The resource type that is associated with the attribute set.


        :param associated_resource_type: The associated_resource_type of this AssociatedResourceSummary.
        :type: str
        """
        allowed_values = ["AUDIT_POLICY"]
        if not value_allowed_none_or_none_sentinel(associated_resource_type, allowed_values):
            associated_resource_type = 'UNKNOWN_ENUM_VALUE'
        self._associated_resource_type = associated_resource_type

    @property
    def associated_resource_id(self):
        """
        Gets the associated_resource_id of this AssociatedResourceSummary.
        The OCID of the resource that is associated with the attribute set.


        :return: The associated_resource_id of this AssociatedResourceSummary.
        :rtype: str
        """
        return self._associated_resource_id

    @associated_resource_id.setter
    def associated_resource_id(self, associated_resource_id):
        """
        Sets the associated_resource_id of this AssociatedResourceSummary.
        The OCID of the resource that is associated with the attribute set.


        :param associated_resource_id: The associated_resource_id of this AssociatedResourceSummary.
        :type: str
        """
        self._associated_resource_id = associated_resource_id

    @property
    def associated_resource_name(self):
        """
        Gets the associated_resource_name of this AssociatedResourceSummary.
        The display name of the resource that is associated with the attribute set. The name does not have to be unique, and is changeable.


        :return: The associated_resource_name of this AssociatedResourceSummary.
        :rtype: str
        """
        return self._associated_resource_name

    @associated_resource_name.setter
    def associated_resource_name(self, associated_resource_name):
        """
        Sets the associated_resource_name of this AssociatedResourceSummary.
        The display name of the resource that is associated with the attribute set. The name does not have to be unique, and is changeable.


        :param associated_resource_name: The associated_resource_name of this AssociatedResourceSummary.
        :type: str
        """
        self._associated_resource_name = associated_resource_name

    @property
    def time_created(self):
        """
        Gets the time_created of this AssociatedResourceSummary.
        The date and time when associated started between resource and the attribute set, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this AssociatedResourceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AssociatedResourceSummary.
        The date and time when associated started between resource and the attribute set, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this AssociatedResourceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this AssociatedResourceSummary.
        The date and time when associated is removed between resources and the attribute set, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this AssociatedResourceSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AssociatedResourceSummary.
        The date and time when associated is removed between resources and the attribute set, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this AssociatedResourceSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
