# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroupMembersCollection(object):
    """
    The criteria for displaying the members of a target database group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroupMembersCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_databases:
            The value to assign to the target_databases property of this GroupMembersCollection.
        :type target_databases: list[str]

        """
        self.swagger_types = {
            'target_databases': 'list[str]'
        }
        self.attribute_map = {
            'target_databases': 'targetDatabases'
        }
        self._target_databases = None

    @property
    def target_databases(self):
        """
        **[Required]** Gets the target_databases of this GroupMembersCollection.
        List of the OCIDs of the target databases which are members of the target database group.


        :return: The target_databases of this GroupMembersCollection.
        :rtype: list[str]
        """
        return self._target_databases

    @target_databases.setter
    def target_databases(self, target_databases):
        """
        Sets the target_databases of this GroupMembersCollection.
        List of the OCIDs of the target databases which are members of the target database group.


        :param target_databases: The target_databases of this GroupMembersCollection.
        :type: list[str]
        """
        self._target_databases = target_databases

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
