# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .instance_component import InstanceComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericOciResourceInstanceComponent(InstanceComponent):
    """
    Generic OCI resource instance component
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenericOciResourceInstanceComponent object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.GenericOciResourceInstanceComponent.type` attribute
        of this class is ``GENERIC_OCI_RESOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GenericOciResourceInstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"
        :type type: str

        :param name:
            The value to assign to the name property of this GenericOciResourceInstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this GenericOciResourceInstanceComponent.
        :type component_name: str

        :param id:
            The value to assign to the id property of this GenericOciResourceInstanceComponent.
        :type id: str

        :param resource_type:
            The value to assign to the resource_type property of this GenericOciResourceInstanceComponent.
        :type resource_type: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str',
            'id': 'str',
            'resource_type': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName',
            'id': 'id',
            'resource_type': 'resourceType'
        }
        self._type = None
        self._name = None
        self._component_name = None
        self._id = None
        self._resource_type = None
        self._type = 'GENERIC_OCI_RESOURCE'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this GenericOciResourceInstanceComponent.
        OCID of the resource


        :return: The id of this GenericOciResourceInstanceComponent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this GenericOciResourceInstanceComponent.
        OCID of the resource


        :param id: The id of this GenericOciResourceInstanceComponent.
        :type: str
        """
        self._id = id

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this GenericOciResourceInstanceComponent.
        Type of the resource


        :return: The resource_type of this GenericOciResourceInstanceComponent.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this GenericOciResourceInstanceComponent.
        Type of the resource


        :param resource_type: The resource_type of this GenericOciResourceInstanceComponent.
        :type: str
        """
        self._resource_type = resource_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
