# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateModelGroupDetails(object):
    """
    Details for updating a modelGroup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateModelGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateModelGroupDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateModelGroupDetails.
        :type description: str

        :param version_label:
            The value to assign to the version_label property of this UpdateModelGroupDetails.
        :type version_label: str

        :param model_group_version_history_id:
            The value to assign to the model_group_version_history_id property of this UpdateModelGroupDetails.
        :type model_group_version_history_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateModelGroupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateModelGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'version_label': 'str',
            'model_group_version_history_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'version_label': 'versionLabel',
            'model_group_version_history_id': 'modelGroupVersionHistoryId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._version_label = None
        self._model_group_version_history_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateModelGroupDetails.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
         Example: `My ModelGroup`


        :return: The display_name of this UpdateModelGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateModelGroupDetails.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
         Example: `My ModelGroup`


        :param display_name: The display_name of this UpdateModelGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateModelGroupDetails.
        A short description of the modelGroup.


        :return: The description of this UpdateModelGroupDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateModelGroupDetails.
        A short description of the modelGroup.


        :param description: The description of this UpdateModelGroupDetails.
        :type: str
        """
        self._description = description

    @property
    def version_label(self):
        """
        Gets the version_label of this UpdateModelGroupDetails.
        An additional description of the lifecycle state of the model group.


        :return: The version_label of this UpdateModelGroupDetails.
        :rtype: str
        """
        return self._version_label

    @version_label.setter
    def version_label(self, version_label):
        """
        Sets the version_label of this UpdateModelGroupDetails.
        An additional description of the lifecycle state of the model group.


        :param version_label: The version_label of this UpdateModelGroupDetails.
        :type: str
        """
        self._version_label = version_label

    @property
    def model_group_version_history_id(self):
        """
        Gets the model_group_version_history_id of this UpdateModelGroupDetails.
        The `OCID`__ of the model group version history to which the modelGroup will be associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_group_version_history_id of this UpdateModelGroupDetails.
        :rtype: str
        """
        return self._model_group_version_history_id

    @model_group_version_history_id.setter
    def model_group_version_history_id(self, model_group_version_history_id):
        """
        Sets the model_group_version_history_id of this UpdateModelGroupDetails.
        The `OCID`__ of the model group version history to which the modelGroup will be associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_group_version_history_id: The model_group_version_history_id of this UpdateModelGroupDetails.
        :type: str
        """
        self._model_group_version_history_id = model_group_version_history_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateModelGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateModelGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateModelGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateModelGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateModelGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateModelGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateModelGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateModelGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
