# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExascaleConfigDetails(object):
    """
    The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExascaleConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_storage_in_gbs:
            The value to assign to the total_storage_in_gbs property of this ExascaleConfigDetails.
        :type total_storage_in_gbs: int

        :param available_storage_in_gbs:
            The value to assign to the available_storage_in_gbs property of this ExascaleConfigDetails.
        :type available_storage_in_gbs: int

        """
        self.swagger_types = {
            'total_storage_in_gbs': 'int',
            'available_storage_in_gbs': 'int'
        }
        self.attribute_map = {
            'total_storage_in_gbs': 'totalStorageInGBs',
            'available_storage_in_gbs': 'availableStorageInGBs'
        }
        self._total_storage_in_gbs = None
        self._available_storage_in_gbs = None

    @property
    def total_storage_in_gbs(self):
        """
        **[Required]** Gets the total_storage_in_gbs of this ExascaleConfigDetails.
        Storage size needed for Exascale in GBs.


        :return: The total_storage_in_gbs of this ExascaleConfigDetails.
        :rtype: int
        """
        return self._total_storage_in_gbs

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, total_storage_in_gbs):
        """
        Sets the total_storage_in_gbs of this ExascaleConfigDetails.
        Storage size needed for Exascale in GBs.


        :param total_storage_in_gbs: The total_storage_in_gbs of this ExascaleConfigDetails.
        :type: int
        """
        self._total_storage_in_gbs = total_storage_in_gbs

    @property
    def available_storage_in_gbs(self):
        """
        Gets the available_storage_in_gbs of this ExascaleConfigDetails.
        Available storage size for Exascale in GBs.


        :return: The available_storage_in_gbs of this ExascaleConfigDetails.
        :rtype: int
        """
        return self._available_storage_in_gbs

    @available_storage_in_gbs.setter
    def available_storage_in_gbs(self, available_storage_in_gbs):
        """
        Sets the available_storage_in_gbs of this ExascaleConfigDetails.
        Available storage size for Exascale in GBs.


        :param available_storage_in_gbs: The available_storage_in_gbs of this ExascaleConfigDetails.
        :type: int
        """
        self._available_storage_in_gbs = available_storage_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
