# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCloudDbSystemConnectorDetails(object):
    """
    The details required to create a cloud DB system connector.
    """

    #: A constant which can be used with the connector_type property of a CreateCloudDbSystemConnectorDetails.
    #: This constant has a value of "MACS"
    CONNECTOR_TYPE_MACS = "MACS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCloudDbSystemConnectorDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.CreateCloudDbSystemMacsConnectorDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_type:
            The value to assign to the connector_type property of this CreateCloudDbSystemConnectorDetails.
            Allowed values for this property are: "MACS"
        :type connector_type: str

        :param display_name:
            The value to assign to the display_name property of this CreateCloudDbSystemConnectorDetails.
        :type display_name: str

        :param cloud_db_system_id:
            The value to assign to the cloud_db_system_id property of this CreateCloudDbSystemConnectorDetails.
        :type cloud_db_system_id: str

        """
        self.swagger_types = {
            'connector_type': 'str',
            'display_name': 'str',
            'cloud_db_system_id': 'str'
        }
        self.attribute_map = {
            'connector_type': 'connectorType',
            'display_name': 'displayName',
            'cloud_db_system_id': 'cloudDbSystemId'
        }
        self._connector_type = None
        self._display_name = None
        self._cloud_db_system_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['connectorType']

        if type == 'MACS':
            return 'CreateCloudDbSystemMacsConnectorDetails'
        else:
            return 'CreateCloudDbSystemConnectorDetails'

    @property
    def connector_type(self):
        """
        **[Required]** Gets the connector_type of this CreateCloudDbSystemConnectorDetails.
        The type of connector.

        Allowed values for this property are: "MACS"


        :return: The connector_type of this CreateCloudDbSystemConnectorDetails.
        :rtype: str
        """
        return self._connector_type

    @connector_type.setter
    def connector_type(self, connector_type):
        """
        Sets the connector_type of this CreateCloudDbSystemConnectorDetails.
        The type of connector.


        :param connector_type: The connector_type of this CreateCloudDbSystemConnectorDetails.
        :type: str
        """
        allowed_values = ["MACS"]
        if not value_allowed_none_or_none_sentinel(connector_type, allowed_values):
            raise ValueError(
                f"Invalid value for `connector_type`, must be None or one of {allowed_values}"
            )
        self._connector_type = connector_type

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCloudDbSystemConnectorDetails.
        The user-friendly name for the cloud connector. The name does not have to be unique.


        :return: The display_name of this CreateCloudDbSystemConnectorDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCloudDbSystemConnectorDetails.
        The user-friendly name for the cloud connector. The name does not have to be unique.


        :param display_name: The display_name of this CreateCloudDbSystemConnectorDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def cloud_db_system_id(self):
        """
        **[Required]** Gets the cloud_db_system_id of this CreateCloudDbSystemConnectorDetails.
        The `OCID`__ of the cloud DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_db_system_id of this CreateCloudDbSystemConnectorDetails.
        :rtype: str
        """
        return self._cloud_db_system_id

    @cloud_db_system_id.setter
    def cloud_db_system_id(self, cloud_db_system_id):
        """
        Sets the cloud_db_system_id of this CreateCloudDbSystemConnectorDetails.
        The `OCID`__ of the cloud DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_db_system_id: The cloud_db_system_id of this CreateCloudDbSystemConnectorDetails.
        :type: str
        """
        self._cloud_db_system_id = cloud_db_system_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
