# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .database_feature_details import DatabaseFeatureDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseSqlWatchFeatureDetails(DatabaseFeatureDetails):
    """
    The details required to enable the SQL Watch feature.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseSqlWatchFeatureDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.DatabaseSqlWatchFeatureDetails.feature` attribute
        of this class is ``SQLWATCH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature:
            The value to assign to the feature property of this DatabaseSqlWatchFeatureDetails.
            Allowed values for this property are: "DIAGNOSTICS_AND_MANAGEMENT", "DB_LIFECYCLE_MANAGEMENT", "SQLWATCH"
        :type feature: str

        :param database_connection_details:
            The value to assign to the database_connection_details property of this DatabaseSqlWatchFeatureDetails.
        :type database_connection_details: oci.database_management.models.DatabaseConnectionDetails

        :param connector_details:
            The value to assign to the connector_details property of this DatabaseSqlWatchFeatureDetails.
        :type connector_details: oci.database_management.models.ConnectorDetails

        :param can_enable_all_current_pdbs:
            The value to assign to the can_enable_all_current_pdbs property of this DatabaseSqlWatchFeatureDetails.
        :type can_enable_all_current_pdbs: bool

        :param is_auto_enable_pluggable_database:
            The value to assign to the is_auto_enable_pluggable_database property of this DatabaseSqlWatchFeatureDetails.
        :type is_auto_enable_pluggable_database: bool

        """
        self.swagger_types = {
            'feature': 'str',
            'database_connection_details': 'DatabaseConnectionDetails',
            'connector_details': 'ConnectorDetails',
            'can_enable_all_current_pdbs': 'bool',
            'is_auto_enable_pluggable_database': 'bool'
        }
        self.attribute_map = {
            'feature': 'feature',
            'database_connection_details': 'databaseConnectionDetails',
            'connector_details': 'connectorDetails',
            'can_enable_all_current_pdbs': 'canEnableAllCurrentPdbs',
            'is_auto_enable_pluggable_database': 'isAutoEnablePluggableDatabase'
        }
        self._feature = None
        self._database_connection_details = None
        self._connector_details = None
        self._can_enable_all_current_pdbs = None
        self._is_auto_enable_pluggable_database = None
        self._feature = 'SQLWATCH'

    @property
    def can_enable_all_current_pdbs(self):
        """
        Gets the can_enable_all_current_pdbs of this DatabaseSqlWatchFeatureDetails.
        Indicates whether SQL Watch should be enabled for all the current pluggable databases in the container database.


        :return: The can_enable_all_current_pdbs of this DatabaseSqlWatchFeatureDetails.
        :rtype: bool
        """
        return self._can_enable_all_current_pdbs

    @can_enable_all_current_pdbs.setter
    def can_enable_all_current_pdbs(self, can_enable_all_current_pdbs):
        """
        Sets the can_enable_all_current_pdbs of this DatabaseSqlWatchFeatureDetails.
        Indicates whether SQL Watch should be enabled for all the current pluggable databases in the container database.


        :param can_enable_all_current_pdbs: The can_enable_all_current_pdbs of this DatabaseSqlWatchFeatureDetails.
        :type: bool
        """
        self._can_enable_all_current_pdbs = can_enable_all_current_pdbs

    @property
    def is_auto_enable_pluggable_database(self):
        """
        Gets the is_auto_enable_pluggable_database of this DatabaseSqlWatchFeatureDetails.
        Indicates whether SQL Watch should be enabled automatically for all the pluggable databases in the container database.


        :return: The is_auto_enable_pluggable_database of this DatabaseSqlWatchFeatureDetails.
        :rtype: bool
        """
        return self._is_auto_enable_pluggable_database

    @is_auto_enable_pluggable_database.setter
    def is_auto_enable_pluggable_database(self, is_auto_enable_pluggable_database):
        """
        Sets the is_auto_enable_pluggable_database of this DatabaseSqlWatchFeatureDetails.
        Indicates whether SQL Watch should be enabled automatically for all the pluggable databases in the container database.


        :param is_auto_enable_pluggable_database: The is_auto_enable_pluggable_database of this DatabaseSqlWatchFeatureDetails.
        :type: bool
        """
        self._is_auto_enable_pluggable_database = is_auto_enable_pluggable_database

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
