# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChildPdb(object):
    """
    Child PDB for a CDB.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChildPdb object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pdb_id:
            The value to assign to the pdb_id property of this ChildPdb.
        :type pdb_id: str

        :param name:
            The value to assign to the name property of this ChildPdb.
        :type name: str

        :param open_mode:
            The value to assign to the open_mode property of this ChildPdb.
        :type open_mode: str

        :param restricted:
            The value to assign to the restricted property of this ChildPdb.
        :type restricted: str

        :param recovery_status:
            The value to assign to the recovery_status property of this ChildPdb.
        :type recovery_status: str

        :param last_changed_by:
            The value to assign to the last_changed_by property of this ChildPdb.
        :type last_changed_by: str

        """
        self.swagger_types = {
            'pdb_id': 'str',
            'name': 'str',
            'open_mode': 'str',
            'restricted': 'str',
            'recovery_status': 'str',
            'last_changed_by': 'str'
        }
        self.attribute_map = {
            'pdb_id': 'pdbId',
            'name': 'name',
            'open_mode': 'openMode',
            'restricted': 'restricted',
            'recovery_status': 'recoveryStatus',
            'last_changed_by': 'lastChangedBy'
        }
        self._pdb_id = None
        self._name = None
        self._open_mode = None
        self._restricted = None
        self._recovery_status = None
        self._last_changed_by = None

    @property
    def pdb_id(self):
        """
        **[Required]** Gets the pdb_id of this ChildPdb.
        Identifier for the pluggable database.


        :return: The pdb_id of this ChildPdb.
        :rtype: str
        """
        return self._pdb_id

    @pdb_id.setter
    def pdb_id(self, pdb_id):
        """
        Sets the pdb_id of this ChildPdb.
        Identifier for the pluggable database.


        :param pdb_id: The pdb_id of this ChildPdb.
        :type: str
        """
        self._pdb_id = pdb_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ChildPdb.
        Name fo the pluggable database.


        :return: The name of this ChildPdb.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ChildPdb.
        Name fo the pluggable database.


        :param name: The name of this ChildPdb.
        :type: str
        """
        self._name = name

    @property
    def open_mode(self):
        """
        **[Required]** Gets the open_mode of this ChildPdb.
        Open mode


        :return: The open_mode of this ChildPdb.
        :rtype: str
        """
        return self._open_mode

    @open_mode.setter
    def open_mode(self, open_mode):
        """
        Sets the open_mode of this ChildPdb.
        Open mode


        :param open_mode: The open_mode of this ChildPdb.
        :type: str
        """
        self._open_mode = open_mode

    @property
    def restricted(self):
        """
        **[Required]** Gets the restricted of this ChildPdb.
        Restricted


        :return: The restricted of this ChildPdb.
        :rtype: str
        """
        return self._restricted

    @restricted.setter
    def restricted(self, restricted):
        """
        Sets the restricted of this ChildPdb.
        Restricted


        :param restricted: The restricted of this ChildPdb.
        :type: str
        """
        self._restricted = restricted

    @property
    def recovery_status(self):
        """
        **[Required]** Gets the recovery_status of this ChildPdb.
        Recovery status


        :return: The recovery_status of this ChildPdb.
        :rtype: str
        """
        return self._recovery_status

    @recovery_status.setter
    def recovery_status(self, recovery_status):
        """
        Sets the recovery_status of this ChildPdb.
        Recovery status


        :param recovery_status: The recovery_status of this ChildPdb.
        :type: str
        """
        self._recovery_status = recovery_status

    @property
    def last_changed_by(self):
        """
        **[Required]** Gets the last_changed_by of this ChildPdb.
        Last changed by


        :return: The last_changed_by of this ChildPdb.
        :rtype: str
        """
        return self._last_changed_by

    @last_changed_by.setter
    def last_changed_by(self, last_changed_by):
        """
        Sets the last_changed_by of this ChildPdb.
        Last changed by


        :param last_changed_by: The last_changed_by of this ChildPdb.
        :type: str
        """
        self._last_changed_by = last_changed_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
