# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilitySummary(object):
    """
    The vulnerability summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilitySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cve_id:
            The value to assign to the cve_id property of this VulnerabilitySummary.
        :type cve_id: str

        :param description:
            The value to assign to the description property of this VulnerabilitySummary.
        :type description: str

        :param risk_level:
            The value to assign to the risk_level property of this VulnerabilitySummary.
        :type risk_level: str

        :param score:
            The value to assign to the score property of this VulnerabilitySummary.
        :type score: str

        :param vulnerable_resources_count:
            The value to assign to the vulnerable_resources_count property of this VulnerabilitySummary.
        :type vulnerable_resources_count: int

        """
        self.swagger_types = {
            'cve_id': 'str',
            'description': 'str',
            'risk_level': 'str',
            'score': 'str',
            'vulnerable_resources_count': 'int'
        }
        self.attribute_map = {
            'cve_id': 'cveId',
            'description': 'description',
            'risk_level': 'riskLevel',
            'score': 'score',
            'vulnerable_resources_count': 'vulnerableResourcesCount'
        }
        self._cve_id = None
        self._description = None
        self._risk_level = None
        self._score = None
        self._vulnerable_resources_count = None

    @property
    def cve_id(self):
        """
        **[Required]** Gets the cve_id of this VulnerabilitySummary.
        CVE vulnerability ID


        :return: The cve_id of this VulnerabilitySummary.
        :rtype: str
        """
        return self._cve_id

    @cve_id.setter
    def cve_id(self, cve_id):
        """
        Sets the cve_id of this VulnerabilitySummary.
        CVE vulnerability ID


        :param cve_id: The cve_id of this VulnerabilitySummary.
        :type: str
        """
        self._cve_id = cve_id

    @property
    def description(self):
        """
        **[Required]** Gets the description of this VulnerabilitySummary.
        Vulnerability description


        :return: The description of this VulnerabilitySummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VulnerabilitySummary.
        Vulnerability description


        :param description: The description of this VulnerabilitySummary.
        :type: str
        """
        self._description = description

    @property
    def risk_level(self):
        """
        **[Required]** Gets the risk_level of this VulnerabilitySummary.
        Risk level enumeration


        :return: The risk_level of this VulnerabilitySummary.
        :rtype: str
        """
        return self._risk_level

    @risk_level.setter
    def risk_level(self, risk_level):
        """
        Sets the risk_level of this VulnerabilitySummary.
        Risk level enumeration


        :param risk_level: The risk_level of this VulnerabilitySummary.
        :type: str
        """
        self._risk_level = risk_level

    @property
    def score(self):
        """
        **[Required]** Gets the score of this VulnerabilitySummary.
        Vulnerability score


        :return: The score of this VulnerabilitySummary.
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this VulnerabilitySummary.
        Vulnerability score


        :param score: The score of this VulnerabilitySummary.
        :type: str
        """
        self._score = score

    @property
    def vulnerable_resources_count(self):
        """
        **[Required]** Gets the vulnerable_resources_count of this VulnerabilitySummary.
        Number of vulnerable resources


        :return: The vulnerable_resources_count of this VulnerabilitySummary.
        :rtype: int
        """
        return self._vulnerable_resources_count

    @vulnerable_resources_count.setter
    def vulnerable_resources_count(self, vulnerable_resources_count):
        """
        Sets the vulnerable_resources_count of this VulnerabilitySummary.
        Number of vulnerable resources


        :param vulnerable_resources_count: The vulnerable_resources_count of this VulnerabilitySummary.
        :type: int
        """
        self._vulnerable_resources_count = vulnerable_resources_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
