# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .merge_check import MergeCheck
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BuildMergeCheck(MergeCheck):
    """
    The status of the build pipelines.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BuildMergeCheck object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.BuildMergeCheck.type` attribute
        of this class is ``BUILD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this BuildMergeCheck.
            Allowed values for this property are: "CONFLICT", "APPROVAL_RULE", "BUILD"
        :type type: str

        :param pipeline_id:
            The value to assign to the pipeline_id property of this BuildMergeCheck.
        :type pipeline_id: str

        :param build_run_id:
            The value to assign to the build_run_id property of this BuildMergeCheck.
        :type build_run_id: str

        :param build_status:
            The value to assign to the build_status property of this BuildMergeCheck.
        :type build_status: str

        """
        self.swagger_types = {
            'type': 'str',
            'pipeline_id': 'str',
            'build_run_id': 'str',
            'build_status': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'pipeline_id': 'pipelineId',
            'build_run_id': 'buildRunId',
            'build_status': 'buildStatus'
        }
        self._type = None
        self._pipeline_id = None
        self._build_run_id = None
        self._build_status = None
        self._type = 'BUILD'

    @property
    def pipeline_id(self):
        """
        Gets the pipeline_id of this BuildMergeCheck.
        The pipeline OCID.


        :return: The pipeline_id of this BuildMergeCheck.
        :rtype: str
        """
        return self._pipeline_id

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id):
        """
        Sets the pipeline_id of this BuildMergeCheck.
        The pipeline OCID.


        :param pipeline_id: The pipeline_id of this BuildMergeCheck.
        :type: str
        """
        self._pipeline_id = pipeline_id

    @property
    def build_run_id(self):
        """
        Gets the build_run_id of this BuildMergeCheck.
        The build run OCID.


        :return: The build_run_id of this BuildMergeCheck.
        :rtype: str
        """
        return self._build_run_id

    @build_run_id.setter
    def build_run_id(self, build_run_id):
        """
        Sets the build_run_id of this BuildMergeCheck.
        The build run OCID.


        :param build_run_id: The build_run_id of this BuildMergeCheck.
        :type: str
        """
        self._build_run_id = build_run_id

    @property
    def build_status(self):
        """
        Gets the build_status of this BuildMergeCheck.
        The status of the build.


        :return: The build_status of this BuildMergeCheck.
        :rtype: str
        """
        return self._build_status

    @build_status.setter
    def build_status(self, build_status):
        """
        Sets the build_status of this BuildMergeCheck.
        The status of the build.


        :param build_status: The build_status of this BuildMergeCheck.
        :type: str
        """
        self._build_status = build_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
