# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestSummary(object):
    """
    Summary of the Pull Request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PullRequestSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PullRequestSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PullRequestSummary.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this PullRequestSummary.
        :type description: str

        :param repository_id:
            The value to assign to the repository_id property of this PullRequestSummary.
        :type repository_id: str

        :param source_repository_id:
            The value to assign to the source_repository_id property of this PullRequestSummary.
        :type source_repository_id: str

        :param source_branch:
            The value to assign to the source_branch property of this PullRequestSummary.
        :type source_branch: str

        :param destination_branch:
            The value to assign to the destination_branch property of this PullRequestSummary.
        :type destination_branch: str

        :param source_commit_id_at_termination:
            The value to assign to the source_commit_id_at_termination property of this PullRequestSummary.
        :type source_commit_id_at_termination: str

        :param merge_base_commit_id_at_termination:
            The value to assign to the merge_base_commit_id_at_termination property of this PullRequestSummary.
        :type merge_base_commit_id_at_termination: str

        :param time_created:
            The value to assign to the time_created property of this PullRequestSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PullRequestSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PullRequestSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PullRequestSummary.
        :type lifecycle_details: str

        :param total_comments:
            The value to assign to the total_comments property of this PullRequestSummary.
        :type total_comments: int

        :param total_reviewers:
            The value to assign to the total_reviewers property of this PullRequestSummary.
        :type total_reviewers: int

        :param created_by:
            The value to assign to the created_by property of this PullRequestSummary.
        :type created_by: oci.devops.models.PrincipalDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PullRequestSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PullRequestSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PullRequestSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'repository_id': 'str',
            'source_repository_id': 'str',
            'source_branch': 'str',
            'destination_branch': 'str',
            'source_commit_id_at_termination': 'str',
            'merge_base_commit_id_at_termination': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'total_comments': 'int',
            'total_reviewers': 'int',
            'created_by': 'PrincipalDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'repository_id': 'repositoryId',
            'source_repository_id': 'sourceRepositoryId',
            'source_branch': 'sourceBranch',
            'destination_branch': 'destinationBranch',
            'source_commit_id_at_termination': 'sourceCommitIdAtTermination',
            'merge_base_commit_id_at_termination': 'mergeBaseCommitIdAtTermination',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'total_comments': 'totalComments',
            'total_reviewers': 'totalReviewers',
            'created_by': 'createdBy',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._description = None
        self._repository_id = None
        self._source_repository_id = None
        self._source_branch = None
        self._destination_branch = None
        self._source_commit_id_at_termination = None
        self._merge_base_commit_id_at_termination = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._total_comments = None
        self._total_reviewers = None
        self._created_by = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PullRequestSummary.
        Unique identifier that is immutable on creation


        :return: The id of this PullRequestSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PullRequestSummary.
        Unique identifier that is immutable on creation


        :param id: The id of this PullRequestSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PullRequestSummary.
        Pull Request title, can be renamed


        :return: The display_name of this PullRequestSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PullRequestSummary.
        Pull Request title, can be renamed


        :param display_name: The display_name of this PullRequestSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PullRequestSummary.
        Compartment Identifier


        :return: The compartment_id of this PullRequestSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PullRequestSummary.
        Compartment Identifier


        :param compartment_id: The compartment_id of this PullRequestSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this PullRequestSummary.
        Details of the pull request. Avoid entering confidential information.


        :return: The description of this PullRequestSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PullRequestSummary.
        Details of the pull request. Avoid entering confidential information.


        :param description: The description of this PullRequestSummary.
        :type: str
        """
        self._description = description

    @property
    def repository_id(self):
        """
        **[Required]** Gets the repository_id of this PullRequestSummary.
        DevOps Repository Identifier


        :return: The repository_id of this PullRequestSummary.
        :rtype: str
        """
        return self._repository_id

    @repository_id.setter
    def repository_id(self, repository_id):
        """
        Sets the repository_id of this PullRequestSummary.
        DevOps Repository Identifier


        :param repository_id: The repository_id of this PullRequestSummary.
        :type: str
        """
        self._repository_id = repository_id

    @property
    def source_repository_id(self):
        """
        Gets the source_repository_id of this PullRequestSummary.
        The OCID of the forked repository that will act as the source of the changes to be included in the pull request against the parent repository.


        :return: The source_repository_id of this PullRequestSummary.
        :rtype: str
        """
        return self._source_repository_id

    @source_repository_id.setter
    def source_repository_id(self, source_repository_id):
        """
        Sets the source_repository_id of this PullRequestSummary.
        The OCID of the forked repository that will act as the source of the changes to be included in the pull request against the parent repository.


        :param source_repository_id: The source_repository_id of this PullRequestSummary.
        :type: str
        """
        self._source_repository_id = source_repository_id

    @property
    def source_branch(self):
        """
        **[Required]** Gets the source_branch of this PullRequestSummary.
        The review branch which contains the changes to be reviewed.


        :return: The source_branch of this PullRequestSummary.
        :rtype: str
        """
        return self._source_branch

    @source_branch.setter
    def source_branch(self, source_branch):
        """
        Sets the source_branch of this PullRequestSummary.
        The review branch which contains the changes to be reviewed.


        :param source_branch: The source_branch of this PullRequestSummary.
        :type: str
        """
        self._source_branch = source_branch

    @property
    def destination_branch(self):
        """
        **[Required]** Gets the destination_branch of this PullRequestSummary.
        The destination branch against which the changes are to be reviewed.


        :return: The destination_branch of this PullRequestSummary.
        :rtype: str
        """
        return self._destination_branch

    @destination_branch.setter
    def destination_branch(self, destination_branch):
        """
        Sets the destination_branch of this PullRequestSummary.
        The destination branch against which the changes are to be reviewed.


        :param destination_branch: The destination_branch of this PullRequestSummary.
        :type: str
        """
        self._destination_branch = destination_branch

    @property
    def source_commit_id_at_termination(self):
        """
        Gets the source_commit_id_at_termination of this PullRequestSummary.
        The source branch commit ID when the Pull Request status was last changed to merged or closed


        :return: The source_commit_id_at_termination of this PullRequestSummary.
        :rtype: str
        """
        return self._source_commit_id_at_termination

    @source_commit_id_at_termination.setter
    def source_commit_id_at_termination(self, source_commit_id_at_termination):
        """
        Sets the source_commit_id_at_termination of this PullRequestSummary.
        The source branch commit ID when the Pull Request status was last changed to merged or closed


        :param source_commit_id_at_termination: The source_commit_id_at_termination of this PullRequestSummary.
        :type: str
        """
        self._source_commit_id_at_termination = source_commit_id_at_termination

    @property
    def merge_base_commit_id_at_termination(self):
        """
        Gets the merge_base_commit_id_at_termination of this PullRequestSummary.
        The merge base commit ID when the Pull Request status was last changed to merged or closed


        :return: The merge_base_commit_id_at_termination of this PullRequestSummary.
        :rtype: str
        """
        return self._merge_base_commit_id_at_termination

    @merge_base_commit_id_at_termination.setter
    def merge_base_commit_id_at_termination(self, merge_base_commit_id_at_termination):
        """
        Sets the merge_base_commit_id_at_termination of this PullRequestSummary.
        The merge base commit ID when the Pull Request status was last changed to merged or closed


        :param merge_base_commit_id_at_termination: The merge_base_commit_id_at_termination of this PullRequestSummary.
        :type: str
        """
        self._merge_base_commit_id_at_termination = merge_base_commit_id_at_termination

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PullRequestSummary.
        The time the the Pull Request was created. An RFC3339 formatted datetime string


        :return: The time_created of this PullRequestSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PullRequestSummary.
        The time the the Pull Request was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this PullRequestSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PullRequestSummary.
        The time the Pull Request was updated. An RFC3339 formatted datetime string


        :return: The time_updated of this PullRequestSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PullRequestSummary.
        The time the Pull Request was updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this PullRequestSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PullRequestSummary.
        The current state of the Pull Request.


        :return: The lifecycle_state of this PullRequestSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PullRequestSummary.
        The current state of the Pull Request.


        :param lifecycle_state: The lifecycle_state of this PullRequestSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this PullRequestSummary.
        The status of the Pull Request.


        :return: The lifecycle_details of this PullRequestSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PullRequestSummary.
        The status of the Pull Request.


        :param lifecycle_details: The lifecycle_details of this PullRequestSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def total_comments(self):
        """
        **[Required]** Gets the total_comments of this PullRequestSummary.
        The total number of comments on the pull request.


        :return: The total_comments of this PullRequestSummary.
        :rtype: int
        """
        return self._total_comments

    @total_comments.setter
    def total_comments(self, total_comments):
        """
        Sets the total_comments of this PullRequestSummary.
        The total number of comments on the pull request.


        :param total_comments: The total_comments of this PullRequestSummary.
        :type: int
        """
        self._total_comments = total_comments

    @property
    def total_reviewers(self):
        """
        **[Required]** Gets the total_reviewers of this PullRequestSummary.
        The total number of reviewers on the pull request.


        :return: The total_reviewers of this PullRequestSummary.
        :rtype: int
        """
        return self._total_reviewers

    @total_reviewers.setter
    def total_reviewers(self, total_reviewers):
        """
        Sets the total_reviewers of this PullRequestSummary.
        The total number of reviewers on the pull request.


        :param total_reviewers: The total_reviewers of this PullRequestSummary.
        :type: int
        """
        self._total_reviewers = total_reviewers

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this PullRequestSummary.

        :return: The created_by of this PullRequestSummary.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this PullRequestSummary.

        :param created_by: The created_by of this PullRequestSummary.
        :type: oci.devops.models.PrincipalDetails
        """
        self._created_by = created_by

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this PullRequestSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PullRequestSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PullRequestSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PullRequestSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this PullRequestSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PullRequestSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PullRequestSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PullRequestSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this PullRequestSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this PullRequestSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PullRequestSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this PullRequestSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
