# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdbUpdateDetail(object):
    """
    Details to update an Oracle Autonomous Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdbUpdateDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this AdbUpdateDetail.
        :type instance_id: str

        :param ecpu:
            The value to assign to the ecpu property of this AdbUpdateDetail.
        :type ecpu: int

        :param data_storage_size_in_tbs:
            The value to assign to the data_storage_size_in_tbs property of this AdbUpdateDetail.
        :type data_storage_size_in_tbs: int

        :param is_mtls_connection_required:
            The value to assign to the is_mtls_connection_required property of this AdbUpdateDetail.
        :type is_mtls_connection_required: bool

        """
        self.swagger_types = {
            'instance_id': 'str',
            'ecpu': 'int',
            'data_storage_size_in_tbs': 'int',
            'is_mtls_connection_required': 'bool'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'ecpu': 'ecpu',
            'data_storage_size_in_tbs': 'dataStorageSizeInTBs',
            'is_mtls_connection_required': 'isMtlsConnectionRequired'
        }
        self._instance_id = None
        self._ecpu = None
        self._data_storage_size_in_tbs = None
        self._is_mtls_connection_required = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AdbUpdateDetail.
        Id of the existing ADB instance.


        :return: The instance_id of this AdbUpdateDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AdbUpdateDetail.
        Id of the existing ADB instance.


        :param instance_id: The instance_id of this AdbUpdateDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def ecpu(self):
        """
        Gets the ecpu of this AdbUpdateDetail.
        The compute amount (ECPUs) available to the database.


        :return: The ecpu of this AdbUpdateDetail.
        :rtype: int
        """
        return self._ecpu

    @ecpu.setter
    def ecpu(self, ecpu):
        """
        Sets the ecpu of this AdbUpdateDetail.
        The compute amount (ECPUs) available to the database.


        :param ecpu: The ecpu of this AdbUpdateDetail.
        :type: int
        """
        self._ecpu = ecpu

    @property
    def data_storage_size_in_tbs(self):
        """
        Gets the data_storage_size_in_tbs of this AdbUpdateDetail.
        The size, in terabytes, of the data volume that will be created and attached to the database.


        :return: The data_storage_size_in_tbs of this AdbUpdateDetail.
        :rtype: int
        """
        return self._data_storage_size_in_tbs

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, data_storage_size_in_tbs):
        """
        Sets the data_storage_size_in_tbs of this AdbUpdateDetail.
        The size, in terabytes, of the data volume that will be created and attached to the database.


        :param data_storage_size_in_tbs: The data_storage_size_in_tbs of this AdbUpdateDetail.
        :type: int
        """
        self._data_storage_size_in_tbs = data_storage_size_in_tbs

    @property
    def is_mtls_connection_required(self):
        """
        Gets the is_mtls_connection_required of this AdbUpdateDetail.
        Specifies if the Autonomous Database requires mTLS connections.


        :return: The is_mtls_connection_required of this AdbUpdateDetail.
        :rtype: bool
        """
        return self._is_mtls_connection_required

    @is_mtls_connection_required.setter
    def is_mtls_connection_required(self, is_mtls_connection_required):
        """
        Sets the is_mtls_connection_required of this AdbUpdateDetail.
        Specifies if the Autonomous Database requires mTLS connections.


        :param is_mtls_connection_required: The is_mtls_connection_required of this AdbUpdateDetail.
        :type: bool
        """
        self._is_mtls_connection_required = is_mtls_connection_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
