# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NsgVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NsgVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vcn_id:
            The value to assign to the vcn_id property of this NsgVariableDependsOn.
        :type vcn_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this NsgVariableDependsOn.
        :type compartment_id: str

        """
        self.swagger_types = {
            'vcn_id': 'str',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'vcn_id': 'vcnId',
            'compartment_id': 'compartmentId'
        }
        self._vcn_id = None
        self._compartment_id = None

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this NsgVariableDependsOn.
        OCID of the VCN.


        :return: The vcn_id of this NsgVariableDependsOn.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this NsgVariableDependsOn.
        OCID of the VCN.


        :param vcn_id: The vcn_id of this NsgVariableDependsOn.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this NsgVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this NsgVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this NsgVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this NsgVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
