# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .execution_details import ExecutionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TerraformBasedExecutionDetails(ExecutionDetails):
    """
    Details for Terraform execution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TerraformBasedExecutionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.TerraformBasedExecutionDetails.execution_type` attribute
        of this class is ``TERRAFORM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param execution_type:
            The value to assign to the execution_type property of this TerraformBasedExecutionDetails.
            Allowed values for this property are: "SCRIPT", "API", "TERRAFORM"
        :type execution_type: str

        :param catalog_id:
            The value to assign to the catalog_id property of this TerraformBasedExecutionDetails.
        :type catalog_id: str

        :param config_file:
            The value to assign to the config_file property of this TerraformBasedExecutionDetails.
        :type config_file: str

        :param target_compartment_id:
            The value to assign to the target_compartment_id property of this TerraformBasedExecutionDetails.
        :type target_compartment_id: str

        :param is_read_output_variable_enabled:
            The value to assign to the is_read_output_variable_enabled property of this TerraformBasedExecutionDetails.
        :type is_read_output_variable_enabled: bool

        :param system_variables:
            The value to assign to the system_variables property of this TerraformBasedExecutionDetails.
        :type system_variables: list[str]

        """
        self.swagger_types = {
            'execution_type': 'str',
            'catalog_id': 'str',
            'config_file': 'str',
            'target_compartment_id': 'str',
            'is_read_output_variable_enabled': 'bool',
            'system_variables': 'list[str]'
        }
        self.attribute_map = {
            'execution_type': 'executionType',
            'catalog_id': 'catalogId',
            'config_file': 'configFile',
            'target_compartment_id': 'targetCompartmentId',
            'is_read_output_variable_enabled': 'isReadOutputVariableEnabled',
            'system_variables': 'systemVariables'
        }
        self._execution_type = None
        self._catalog_id = None
        self._config_file = None
        self._target_compartment_id = None
        self._is_read_output_variable_enabled = None
        self._system_variables = None
        self._execution_type = 'TERRAFORM'

    @property
    def catalog_id(self):
        """
        **[Required]** Gets the catalog_id of this TerraformBasedExecutionDetails.
        Catalog Id having terraform package.


        :return: The catalog_id of this TerraformBasedExecutionDetails.
        :rtype: str
        """
        return self._catalog_id

    @catalog_id.setter
    def catalog_id(self, catalog_id):
        """
        Sets the catalog_id of this TerraformBasedExecutionDetails.
        Catalog Id having terraform package.


        :param catalog_id: The catalog_id of this TerraformBasedExecutionDetails.
        :type: str
        """
        self._catalog_id = catalog_id

    @property
    def config_file(self):
        """
        Gets the config_file of this TerraformBasedExecutionDetails.
        Catalog Id having config file.


        :return: The config_file of this TerraformBasedExecutionDetails.
        :rtype: str
        """
        return self._config_file

    @config_file.setter
    def config_file(self, config_file):
        """
        Sets the config_file of this TerraformBasedExecutionDetails.
        Catalog Id having config file.


        :param config_file: The config_file of this TerraformBasedExecutionDetails.
        :type: str
        """
        self._config_file = config_file

    @property
    def target_compartment_id(self):
        """
        **[Required]** Gets the target_compartment_id of this TerraformBasedExecutionDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The target_compartment_id of this TerraformBasedExecutionDetails.
        :rtype: str
        """
        return self._target_compartment_id

    @target_compartment_id.setter
    def target_compartment_id(self, target_compartment_id):
        """
        Sets the target_compartment_id of this TerraformBasedExecutionDetails.
        OCID of the compartment to which the resource belongs to.


        :param target_compartment_id: The target_compartment_id of this TerraformBasedExecutionDetails.
        :type: str
        """
        self._target_compartment_id = target_compartment_id

    @property
    def is_read_output_variable_enabled(self):
        """
        Gets the is_read_output_variable_enabled of this TerraformBasedExecutionDetails.
        Is read output variable enabled


        :return: The is_read_output_variable_enabled of this TerraformBasedExecutionDetails.
        :rtype: bool
        """
        return self._is_read_output_variable_enabled

    @is_read_output_variable_enabled.setter
    def is_read_output_variable_enabled(self, is_read_output_variable_enabled):
        """
        Sets the is_read_output_variable_enabled of this TerraformBasedExecutionDetails.
        Is read output variable enabled


        :param is_read_output_variable_enabled: The is_read_output_variable_enabled of this TerraformBasedExecutionDetails.
        :type: bool
        """
        self._is_read_output_variable_enabled = is_read_output_variable_enabled

    @property
    def system_variables(self):
        """
        Gets the system_variables of this TerraformBasedExecutionDetails.
        The list of system variables.


        :return: The system_variables of this TerraformBasedExecutionDetails.
        :rtype: list[str]
        """
        return self._system_variables

    @system_variables.setter
    def system_variables(self, system_variables):
        """
        Sets the system_variables of this TerraformBasedExecutionDetails.
        The list of system variables.


        :param system_variables: The system_variables of this TerraformBasedExecutionDetails.
        :type: list[str]
        """
        self._system_variables = system_variables

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
