# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MembershipSummary(object):
    """
    Summary of an Exadata Fleet Update Collection containing a target.
    """

    #: A constant which can be used with the fsu_collection_type property of a MembershipSummary.
    #: This constant has a value of "DB"
    FSU_COLLECTION_TYPE_DB = "DB"

    #: A constant which can be used with the fsu_collection_type property of a MembershipSummary.
    #: This constant has a value of "GI"
    FSU_COLLECTION_TYPE_GI = "GI"

    #: A constant which can be used with the fsu_collection_type property of a MembershipSummary.
    #: This constant has a value of "GUEST_OS"
    FSU_COLLECTION_TYPE_GUEST_OS = "GUEST_OS"

    #: A constant which can be used with the fsu_collection_type property of a MembershipSummary.
    #: This constant has a value of "EXADB_STACK"
    FSU_COLLECTION_TYPE_EXADB_STACK = "EXADB_STACK"

    def __init__(self, **kwargs):
        """
        Initializes a new MembershipSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fsu_collection_id:
            The value to assign to the fsu_collection_id property of this MembershipSummary.
        :type fsu_collection_id: str

        :param fsu_collection_type:
            The value to assign to the fsu_collection_type property of this MembershipSummary.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type fsu_collection_type: str

        :param fsu_collection_name:
            The value to assign to the fsu_collection_name property of this MembershipSummary.
        :type fsu_collection_name: str

        """
        self.swagger_types = {
            'fsu_collection_id': 'str',
            'fsu_collection_type': 'str',
            'fsu_collection_name': 'str'
        }
        self.attribute_map = {
            'fsu_collection_id': 'fsuCollectionId',
            'fsu_collection_type': 'fsuCollectionType',
            'fsu_collection_name': 'fsuCollectionName'
        }
        self._fsu_collection_id = None
        self._fsu_collection_type = None
        self._fsu_collection_name = None

    @property
    def fsu_collection_id(self):
        """
        **[Required]** Gets the fsu_collection_id of this MembershipSummary.
        The `OCID`__ of the Exadata Fleet Update Collection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fsu_collection_id of this MembershipSummary.
        :rtype: str
        """
        return self._fsu_collection_id

    @fsu_collection_id.setter
    def fsu_collection_id(self, fsu_collection_id):
        """
        Sets the fsu_collection_id of this MembershipSummary.
        The `OCID`__ of the Exadata Fleet Update Collection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fsu_collection_id: The fsu_collection_id of this MembershipSummary.
        :type: str
        """
        self._fsu_collection_id = fsu_collection_id

    @property
    def fsu_collection_type(self):
        """
        **[Required]** Gets the fsu_collection_type of this MembershipSummary.
        Type of Exadata Fleet Update Collection.

        Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The fsu_collection_type of this MembershipSummary.
        :rtype: str
        """
        return self._fsu_collection_type

    @fsu_collection_type.setter
    def fsu_collection_type(self, fsu_collection_type):
        """
        Sets the fsu_collection_type of this MembershipSummary.
        Type of Exadata Fleet Update Collection.


        :param fsu_collection_type: The fsu_collection_type of this MembershipSummary.
        :type: str
        """
        allowed_values = ["DB", "GI", "GUEST_OS", "EXADB_STACK"]
        if not value_allowed_none_or_none_sentinel(fsu_collection_type, allowed_values):
            fsu_collection_type = 'UNKNOWN_ENUM_VALUE'
        self._fsu_collection_type = fsu_collection_type

    @property
    def fsu_collection_name(self):
        """
        **[Required]** Gets the fsu_collection_name of this MembershipSummary.
        The user-friendly name for the Exadata Fleet Update Collection.


        :return: The fsu_collection_name of this MembershipSummary.
        :rtype: str
        """
        return self._fsu_collection_name

    @fsu_collection_name.setter
    def fsu_collection_name(self, fsu_collection_name):
        """
        Sets the fsu_collection_name of this MembershipSummary.
        The user-friendly name for the Exadata Fleet Update Collection.


        :param fsu_collection_name: The fsu_collection_name of this MembershipSummary.
        :type: str
        """
        self._fsu_collection_name = fsu_collection_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
