# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .input_location import InputLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InlineInputLocation(InputLocation):
    """
    The details of inline input location.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InlineInputLocation object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.InlineInputLocation.input_location_type` attribute
        of this class is ``INLINE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input_location_type:
            The value to assign to the input_location_type property of this InlineInputLocation.
            Allowed values for this property are: "INLINE", "OBJECT_STORAGE_PREFIX"
        :type input_location_type: str

        :param content:
            The value to assign to the content property of this InlineInputLocation.
        :type content: str

        """
        self.swagger_types = {
            'input_location_type': 'str',
            'content': 'str'
        }
        self.attribute_map = {
            'input_location_type': 'inputLocationType',
            'content': 'content'
        }
        self._input_location_type = None
        self._content = None
        self._input_location_type = 'INLINE'

    @property
    def content(self):
        """
        Gets the content of this InlineInputLocation.
        Inline content as input.


        :return: The content of this InlineInputLocation.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this InlineInputLocation.
        Inline content as input.


        :param content: The content of this InlineInputLocation.
        :type: str
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
