# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .iceberg_storage_summary import IcebergStorageSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AmazonS3IcebergStorageSummary(IcebergStorageSummary):
    """
    Summary of the Amazon S3 storage used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AmazonS3IcebergStorageSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.AmazonS3IcebergStorageSummary.storage_type` attribute
        of this class is ``AMAZON_S3`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this AmazonS3IcebergStorageSummary.
            Allowed values for this property are: "AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"
        :type storage_type: str

        :param scheme_type:
            The value to assign to the scheme_type property of this AmazonS3IcebergStorageSummary.
        :type scheme_type: str

        :param endpoint:
            The value to assign to the endpoint property of this AmazonS3IcebergStorageSummary.
        :type endpoint: str

        :param access_key_id:
            The value to assign to the access_key_id property of this AmazonS3IcebergStorageSummary.
        :type access_key_id: str

        :param secret_access_key_secret_id:
            The value to assign to the secret_access_key_secret_id property of this AmazonS3IcebergStorageSummary.
        :type secret_access_key_secret_id: str

        :param region:
            The value to assign to the region property of this AmazonS3IcebergStorageSummary.
        :type region: str

        :param bucket:
            The value to assign to the bucket property of this AmazonS3IcebergStorageSummary.
        :type bucket: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'scheme_type': 'str',
            'endpoint': 'str',
            'access_key_id': 'str',
            'secret_access_key_secret_id': 'str',
            'region': 'str',
            'bucket': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType',
            'scheme_type': 'schemeType',
            'endpoint': 'endpoint',
            'access_key_id': 'accessKeyId',
            'secret_access_key_secret_id': 'secretAccessKeySecretId',
            'region': 'region',
            'bucket': 'bucket'
        }
        self._storage_type = None
        self._scheme_type = None
        self._endpoint = None
        self._access_key_id = None
        self._secret_access_key_secret_id = None
        self._region = None
        self._bucket = None
        self._storage_type = 'AMAZON_S3'

    @property
    def scheme_type(self):
        """
        **[Required]** Gets the scheme_type of this AmazonS3IcebergStorageSummary.
        The scheme of the storage.


        :return: The scheme_type of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._scheme_type

    @scheme_type.setter
    def scheme_type(self, scheme_type):
        """
        Sets the scheme_type of this AmazonS3IcebergStorageSummary.
        The scheme of the storage.


        :param scheme_type: The scheme_type of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._scheme_type = scheme_type

    @property
    def endpoint(self):
        """
        Gets the endpoint of this AmazonS3IcebergStorageSummary.
        The endpoint URL of the Amazon S3 storage service.
        e.g.: 'https://s3.amazonaws.com'


        :return: The endpoint of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """
        Sets the endpoint of this AmazonS3IcebergStorageSummary.
        The endpoint URL of the Amazon S3 storage service.
        e.g.: 'https://s3.amazonaws.com'


        :param endpoint: The endpoint of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._endpoint = endpoint

    @property
    def access_key_id(self):
        """
        **[Required]** Gets the access_key_id of this AmazonS3IcebergStorageSummary.
        Access key ID to access the Amazon S3 bucket.


        :return: The access_key_id of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._access_key_id

    @access_key_id.setter
    def access_key_id(self, access_key_id):
        """
        Sets the access_key_id of this AmazonS3IcebergStorageSummary.
        Access key ID to access the Amazon S3 bucket.


        :param access_key_id: The access_key_id of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._access_key_id = access_key_id

    @property
    def secret_access_key_secret_id(self):
        """
        **[Required]** Gets the secret_access_key_secret_id of this AmazonS3IcebergStorageSummary.
        The `OCID`__ of the Secret where the Secret Access Key is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The secret_access_key_secret_id of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._secret_access_key_secret_id

    @secret_access_key_secret_id.setter
    def secret_access_key_secret_id(self, secret_access_key_secret_id):
        """
        Sets the secret_access_key_secret_id of this AmazonS3IcebergStorageSummary.
        The `OCID`__ of the Secret where the Secret Access Key is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param secret_access_key_secret_id: The secret_access_key_secret_id of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._secret_access_key_secret_id = secret_access_key_secret_id

    @property
    def region(self):
        """
        **[Required]** Gets the region of this AmazonS3IcebergStorageSummary.
        The AMAZON region where the S3 bucket is hosted.
        e.g.: 'us-east-2'


        :return: The region of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this AmazonS3IcebergStorageSummary.
        The AMAZON region where the S3 bucket is hosted.
        e.g.: 'us-east-2'


        :param region: The region of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._region = region

    @property
    def bucket(self):
        """
        **[Required]** Gets the bucket of this AmazonS3IcebergStorageSummary.
        S3 bucket where Iceberg stores metadata and data files.


        :return: The bucket of this AmazonS3IcebergStorageSummary.
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this AmazonS3IcebergStorageSummary.
        S3 bucket where Iceberg stores metadata and data files.


        :param bucket: The bucket of this AmazonS3IcebergStorageSummary.
        :type: str
        """
        self._bucket = bucket

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
