# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointRequest(object):
    """
    An object containing details to make a REST request.
    """

    #: A constant which can be used with the method property of a EndpointRequest.
    #: This constant has a value of "GET"
    METHOD_GET = "GET"

    #: A constant which can be used with the method property of a EndpointRequest.
    #: This constant has a value of "POST"
    METHOD_POST = "POST"

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param method:
            The value to assign to the method property of this EndpointRequest.
            Allowed values for this property are: "GET", "POST", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type method: str

        :param url:
            The value to assign to the url property of this EndpointRequest.
        :type url: str

        :param content_type:
            The value to assign to the content_type property of this EndpointRequest.
        :type content_type: str

        :param payload:
            The value to assign to the payload property of this EndpointRequest.
        :type payload: str

        :param headers:
            The value to assign to the headers property of this EndpointRequest.
        :type headers: list[oci.log_analytics.models.NameValuePair]

        :param form_parameters:
            The value to assign to the form_parameters property of this EndpointRequest.
        :type form_parameters: list[oci.log_analytics.models.NameValuePair]

        """
        self.swagger_types = {
            'method': 'str',
            'url': 'str',
            'content_type': 'str',
            'payload': 'str',
            'headers': 'list[NameValuePair]',
            'form_parameters': 'list[NameValuePair]'
        }
        self.attribute_map = {
            'method': 'method',
            'url': 'url',
            'content_type': 'contentType',
            'payload': 'payload',
            'headers': 'headers',
            'form_parameters': 'formParameters'
        }
        self._method = None
        self._url = None
        self._content_type = None
        self._payload = None
        self._headers = None
        self._form_parameters = None

    @property
    def method(self):
        """
        Gets the method of this EndpointRequest.
        The endpoint method - GET or POST.

        Allowed values for this property are: "GET", "POST", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The method of this EndpointRequest.
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """
        Sets the method of this EndpointRequest.
        The endpoint method - GET or POST.


        :param method: The method of this EndpointRequest.
        :type: str
        """
        allowed_values = ["GET", "POST"]
        if not value_allowed_none_or_none_sentinel(method, allowed_values):
            method = 'UNKNOWN_ENUM_VALUE'
        self._method = method

    @property
    def url(self):
        """
        **[Required]** Gets the url of this EndpointRequest.
        The request URL.


        :return: The url of this EndpointRequest.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this EndpointRequest.
        The request URL.


        :param url: The url of this EndpointRequest.
        :type: str
        """
        self._url = url

    @property
    def content_type(self):
        """
        Gets the content_type of this EndpointRequest.
        The request content type.


        :return: The content_type of this EndpointRequest.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this EndpointRequest.
        The request content type.


        :param content_type: The content_type of this EndpointRequest.
        :type: str
        """
        self._content_type = content_type

    @property
    def payload(self):
        """
        Gets the payload of this EndpointRequest.
        The request payload, applicable for POST requests.


        :return: The payload of this EndpointRequest.
        :rtype: str
        """
        return self._payload

    @payload.setter
    def payload(self, payload):
        """
        Sets the payload of this EndpointRequest.
        The request payload, applicable for POST requests.


        :param payload: The payload of this EndpointRequest.
        :type: str
        """
        self._payload = payload

    @property
    def headers(self):
        """
        Gets the headers of this EndpointRequest.
        The request headers represented as a list of name-value pairs.


        :return: The headers of this EndpointRequest.
        :rtype: list[oci.log_analytics.models.NameValuePair]
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """
        Sets the headers of this EndpointRequest.
        The request headers represented as a list of name-value pairs.


        :param headers: The headers of this EndpointRequest.
        :type: list[oci.log_analytics.models.NameValuePair]
        """
        self._headers = headers

    @property
    def form_parameters(self):
        """
        Gets the form_parameters of this EndpointRequest.
        The request form parameters represented as a list of name-value pairs.


        :return: The form_parameters of this EndpointRequest.
        :rtype: list[oci.log_analytics.models.NameValuePair]
        """
        return self._form_parameters

    @form_parameters.setter
    def form_parameters(self, form_parameters):
        """
        Sets the form_parameters of this EndpointRequest.
        The request form parameters represented as a list of name-value pairs.


        :param form_parameters: The form_parameters of this EndpointRequest.
        :type: list[oci.log_analytics.models.NameValuePair]
        """
        self._form_parameters = form_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
