# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EstimateRecallDataSizeDetails(object):
    """
    This is the input used to estimate the size of data to be recalled
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EstimateRecallDataSizeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_data_started:
            The value to assign to the time_data_started property of this EstimateRecallDataSizeDetails.
        :type time_data_started: datetime

        :param time_data_ended:
            The value to assign to the time_data_ended property of this EstimateRecallDataSizeDetails.
        :type time_data_ended: datetime

        :param log_sets:
            The value to assign to the log_sets property of this EstimateRecallDataSizeDetails.
        :type log_sets: str

        :param is_recall_new_data_only:
            The value to assign to the is_recall_new_data_only property of this EstimateRecallDataSizeDetails.
        :type is_recall_new_data_only: bool

        """
        self.swagger_types = {
            'time_data_started': 'datetime',
            'time_data_ended': 'datetime',
            'log_sets': 'str',
            'is_recall_new_data_only': 'bool'
        }
        self.attribute_map = {
            'time_data_started': 'timeDataStarted',
            'time_data_ended': 'timeDataEnded',
            'log_sets': 'logSets',
            'is_recall_new_data_only': 'isRecallNewDataOnly'
        }
        self._time_data_started = None
        self._time_data_ended = None
        self._log_sets = None
        self._is_recall_new_data_only = None

    @property
    def time_data_started(self):
        """
        **[Required]** Gets the time_data_started of this EstimateRecallDataSizeDetails.
        This is the start of the time range for the data to be recalled


        :return: The time_data_started of this EstimateRecallDataSizeDetails.
        :rtype: datetime
        """
        return self._time_data_started

    @time_data_started.setter
    def time_data_started(self, time_data_started):
        """
        Sets the time_data_started of this EstimateRecallDataSizeDetails.
        This is the start of the time range for the data to be recalled


        :param time_data_started: The time_data_started of this EstimateRecallDataSizeDetails.
        :type: datetime
        """
        self._time_data_started = time_data_started

    @property
    def time_data_ended(self):
        """
        **[Required]** Gets the time_data_ended of this EstimateRecallDataSizeDetails.
        This is the end of the time range for the data to be recalled


        :return: The time_data_ended of this EstimateRecallDataSizeDetails.
        :rtype: datetime
        """
        return self._time_data_ended

    @time_data_ended.setter
    def time_data_ended(self, time_data_ended):
        """
        Sets the time_data_ended of this EstimateRecallDataSizeDetails.
        This is the end of the time range for the data to be recalled


        :param time_data_ended: The time_data_ended of this EstimateRecallDataSizeDetails.
        :type: datetime
        """
        self._time_data_ended = time_data_ended

    @property
    def log_sets(self):
        """
        Gets the log_sets of this EstimateRecallDataSizeDetails.
        This is the list of logsets to be accounted for in the recalled data


        :return: The log_sets of this EstimateRecallDataSizeDetails.
        :rtype: str
        """
        return self._log_sets

    @log_sets.setter
    def log_sets(self, log_sets):
        """
        Sets the log_sets of this EstimateRecallDataSizeDetails.
        This is the list of logsets to be accounted for in the recalled data


        :param log_sets: The log_sets of this EstimateRecallDataSizeDetails.
        :type: str
        """
        self._log_sets = log_sets

    @property
    def is_recall_new_data_only(self):
        """
        Gets the is_recall_new_data_only of this EstimateRecallDataSizeDetails.
        This indicates if only new data has to be recalled in the timeframe


        :return: The is_recall_new_data_only of this EstimateRecallDataSizeDetails.
        :rtype: bool
        """
        return self._is_recall_new_data_only

    @is_recall_new_data_only.setter
    def is_recall_new_data_only(self, is_recall_new_data_only):
        """
        Sets the is_recall_new_data_only of this EstimateRecallDataSizeDetails.
        This indicates if only new data has to be recalled in the timeframe


        :param is_recall_new_data_only: The is_recall_new_data_only of this EstimateRecallDataSizeDetails.
        :type: bool
        """
        self._is_recall_new_data_only = is_recall_new_data_only

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
