# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateRestDetails(object):
    """
    Details required to configure REST while creating a DB System.
    """

    #: A constant which can be used with the configuration property of a CreateRestDetails.
    #: This constant has a value of "DISABLED"
    CONFIGURATION_DISABLED = "DISABLED"

    #: A constant which can be used with the configuration property of a CreateRestDetails.
    #: This constant has a value of "DBSYSTEM_ONLY"
    CONFIGURATION_DBSYSTEM_ONLY = "DBSYSTEM_ONLY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateRestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param configuration:
            The value to assign to the configuration property of this CreateRestDetails.
            Allowed values for this property are: "DISABLED", "DBSYSTEM_ONLY"
        :type configuration: str

        :param port:
            The value to assign to the port property of this CreateRestDetails.
        :type port: int

        """
        self.swagger_types = {
            'configuration': 'str',
            'port': 'int'
        }
        self.attribute_map = {
            'configuration': 'configuration',
            'port': 'port'
        }
        self._configuration = None
        self._port = None

    @property
    def configuration(self):
        """
        **[Required]** Gets the configuration of this CreateRestDetails.
        Select how REST is configured across the DB System instances.

        Allowed values for this property are: "DISABLED", "DBSYSTEM_ONLY"


        :return: The configuration of this CreateRestDetails.
        :rtype: str
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this CreateRestDetails.
        Select how REST is configured across the DB System instances.


        :param configuration: The configuration of this CreateRestDetails.
        :type: str
        """
        allowed_values = ["DISABLED", "DBSYSTEM_ONLY"]
        if not value_allowed_none_or_none_sentinel(configuration, allowed_values):
            raise ValueError(
                f"Invalid value for `configuration`, must be None or one of {allowed_values}"
            )
        self._configuration = configuration

    @property
    def port(self):
        """
        Gets the port of this CreateRestDetails.
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.


        :return: The port of this CreateRestDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CreateRestDetails.
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.


        :param port: The port of this CreateRestDetails.
        :type: int
        """
        self._port = port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
